/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import org.operamasks.faces.component.grid.GridHeader;
import org.operamasks.faces.component.grid.GridHeaderCell;
import org.operamasks.faces.component.grid.GridHeaderModel;
import org.operamasks.faces.component.grid.UIOutputColumn;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.LoggerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HeaderModelBuilder {
    private static Logger logger = LoggerUtil.getLogger((String)"org.operamasks.faces.view");

    private HeaderModelBuilder() {
    }

    public static GridHeaderModel constructHeaders(GridHeaderModel headerModel, UIComponent column, Class<? extends GridHeaderModel> modelClass) {
        GridHeaderModel resultModel = null;
        GridHeader firstHeader = null;
        try {
            if (headerModel != null) {
                resultModel = headerModel;
                if (headerModel.getHeadersCount() > 0) {
                    if (headerModel.getHeadersCount() > 0) {
                        firstHeader = headerModel.getHeader(0);
                    }
                } else {
                    firstHeader = new GridHeader();
                    resultModel.addHeader(firstHeader);
                }
            } else {
                resultModel = modelClass.newInstance();
                firstHeader = new GridHeader();
                resultModel.addHeader(firstHeader);
            }
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(modelClass.getName() + "is not instantiable", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(modelClass.getName() + "is not instantiable", ex);
        }
        boolean isRendered = column.isRendered();
        if (!isRendered) {
            return resultModel;
        }
        String headerLabel = ((UIOutputColumn)column).getColumnHeader();
        if (headerLabel == null) {
            headerLabel = column.getId();
        }
        HeaderModelBuilder.appendHeaderCell(firstHeader, (UIOutputColumn)column, headerLabel);
        return resultModel;
    }

    private static void appendHeaderCell(GridHeader header, UIOutputColumn col, String headerLabel) {
        GridHeaderCell headerCell = new GridHeaderCell();
        headerCell.setLabel(headerLabel);
        Boolean requireEscape = col.getRequireEscape();
        if (requireEscape == null) {
            requireEscape = Boolean.TRUE;
        }
        headerCell.setRequireEscape(requireEscape);
        header.addCell(headerCell);
    }

    private static <T> T getAttribute(UIComponent comp, String attributeName) {
        Object result;
        try {
            result = comp.getAttributes().get(attributeName);
        }
        catch (Exception ex) {
            logger.finer(ex.getClass().getSimpleName() + " (" + ex.getMessage() + ") occured while reading attribute '" + attributeName + "' on component '" + FacesUtils.getComponentDesc((UIComponent)comp) + "'.");
            return null;
        }
        return (T)result;
    }

    public static GridHeaderModel constructHeaders(GridHeaderModel headerModel, UIComponent column) {
        return HeaderModelBuilder.constructHeaders(headerModel, column, GridHeaderModel.class);
    }
}

