/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectItemsRenderHelper {
    /*
     * Could not resolve type clashes
     */
    public static List<SelectItem> getSelectItems(UIComponent component) {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        for (UIComponent kid : component.getChildren()) {
            Object value;
            if (kid instanceof UISelectItem) {
                UISelectItem item = (UISelectItem)kid;
                list.add(new SelectItem(item.getItemValue(), item.getItemLabel(), item.getItemDescription(), item.isItemDisabled()));
                continue;
            }
            if (!(kid instanceof UISelectItems) || (value = ((UISelectItems)kid).getValue()) == null) continue;
            if (value instanceof SelectItem) {
                list.add((SelectItem)value);
                continue;
            }
            if (value instanceof String) {
                list.add(new SelectItem(value, value.toString()));
                continue;
            }
            if (value instanceof SelectItem[]) {
                for (SelectItem item : (SelectItem[])value) {
                    list.add(item);
                }
                continue;
            }
            if (value instanceof String[]) {
                for (SelectItem str : (String[])value) {
                    list.add(new SelectItem((Object)str, (String)str));
                }
                continue;
            }
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    if (element instanceof SelectItem) {
                        list.add((SelectItem)element);
                        continue;
                    }
                    if (element instanceof String) {
                        list.add(new SelectItem(element, element.toString()));
                        continue;
                    }
                    throw new IllegalArgumentException(Resources._T((String)"UI_FORM_SELECTITEMS_TYPEERROR_MESSAGE"));
                }
                continue;
            }
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (key == null || val == null) continue;
                    list.add(new SelectItem((Object)key.toString(), val.toString()));
                }
                continue;
            }
            throw new IllegalArgumentException(Resources._T((String)"UI_FORM_SELECTITEMS_VALUE_TYPEERROR_MESSAGE"));
        }
        return list;
    }

    public static void updateSelectItems(UIComponent component, List<SelectItem> list) {
        for (UIComponent kid : component.getChildren()) {
            if (kid instanceof UISelectItems) {
                Object value = ((UISelectItems)kid).getValue();
                if (value == null) continue;
                if (value instanceof SelectItem[]) {
                    for (SelectItem item : (SelectItem[])value) {
                        for (SelectItem newItem : list) {
                            if (!item.getLabel().equals(newItem.getLabel())) continue;
                            item.setValue(newItem.getValue());
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException(Resources._T((String)"UI_FORM_SELECTITEMS_INCHECKBOXGROUP_TYPEERROR_MESSAGE"));
            }
            if (!(kid instanceof UISelectItem)) continue;
            for (SelectItem newItem : list) {
                if (!newItem.getLabel().equals(((UISelectItem)kid).getItemLabel())) continue;
                ((UISelectItem)kid).setValue(newItem.getValue());
                ((UISelectItem)kid).setItemValue(newItem.getValue());
            }
        }
    }
}

