/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.form.impl.UICombo;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.toolbar.ToolBarCarrier;
import org.operamasks.faces.component.widget.UIPager;
import org.operamasks.faces.component.widget.UIPagingToolbar;
import org.operamasks.faces.component.widget.UIToolBar;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.container.ContainerRenderUtils;
import org.operamasks.faces.render.container.ToolBarItemRenderer;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.Aliases;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.render.resource.Resource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.HtmlEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarHelper {
    private static final String TOOLBAR_CACHE_EXTERNAL = "cache.external";
    private static final String TOOLBAR_CACHE_INTERNAL = "cache.internal";
    private static final String TOOLBAR_CACHE_EXTERNALPAGING = "cache.externalpaging";
    private static final String TOOLBAR_CACHE_FOR_TARGET = "org.operamasks.faces.toolbar.associate.";

    public static void encodeToolBarButton(final ResourceManager rm, StringBuilder buf, final UIComponent component, String jsvar, UIComponent parent) {
        Formatter fmt = new Formatter(buf);
        fmt.format("%s=new Ext.Toolbar.Button({", jsvar);
        String text = ToolBarHelper.getText(component);
        String tooltip = (String)component.getAttributes().get("tooltip");
        Object disabled = component.getAttributes().get("disabled");
        Object minWidth = component.getAttributes().get("minWidth");
        String icon = RendererUtils.getIcon((UIComponent)component);
        fmt.format("text:%s", HtmlEncoder.enquote((String)text, (Character)Character.valueOf('\'')));
        if (tooltip != null) {
            fmt.format(",tooltip:%s", HtmlEncoder.enquote((String)tooltip, (Character)Character.valueOf('\'')));
        }
        if (disabled != null) {
            fmt.format(",disabled:%b", disabled);
        }
        if (minWidth != null) {
            fmt.format(",minWidth:%s", minWidth);
        }
        if (icon != null) {
            fmt.format(",icon:%s", HtmlEncoder.enquote((String)icon, (Character)Character.valueOf('\'')));
            fmt.format(",iconCls:%s", HtmlEncoder.enquote((String)"x-btn-text-icon", (Character)Character.valueOf('\'')));
        }
        buf.append("});\n");
        FacesContext context = FacesContext.getCurrentInstance();
        if (FacesUtils.isAjaxResponse((FacesContext)context)) {
            if (ToolBarHelper.isToolBarButton(component)) {
                fmt.format("if (typeof %1$s != 'undefined') {\n%2$s.add(%1$s);\n}\n", FacesUtils.getJsvar((FacesContext)context, (UIComponent)component), FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent));
            }
        } else {
            rm.registerResource((Resource)new AbstractResource(ToolBarHelper.getResourceId(component)){

                public int getPriority() {
                    return 700;
                }

                public void encodeBegin(FacesContext context) throws IOException {
                    ToolBarHelper.appendItemToToolBar(rm, component);
                }
            });
        }
    }

    private static String getResourceId(UIComponent component) {
        return "urn:toolBarButton:" + component.getClientId(FacesContext.getCurrentInstance());
    }

    private static String getText(UIComponent component) {
        String text = (String)component.getAttributes().get("label");
        if (text == null) {
            Object value = ((UICommand)component).getValue();
            text = value != null ? value.toString() : "";
        }
        return text;
    }

    private static void appendItemToToolBar(ResourceManager rm, UIComponent component) {
        ComponentResource resource = ComponentResource.registerJS((ResourceManager)rm, (String[])new String[]{"Ext.Toolbar"});
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent parent = component.getParent();
        if (!(parent instanceof UIToolBar) && !(parent instanceof UIPagingToolbar)) {
            return;
        }
        if (ToolBarHelper.isToolBarButton(component)) {
            fmt.format("\nif (typeof %1$s != 'undefined') {\n%2$s.addButton(%1$s);\n}", FacesUtils.getJsvar((FacesContext)context, (UIComponent)component), FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent));
        } else if (ToolBarHelper.isToolBarCombo(component)) {
            fmt.format("\nif (typeof %1$s != 'undefined') {\n%2$s.addField(%1$s);\n}", FacesUtils.getJsvar((FacesContext)context, (UIComponent)component), FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent));
        } else {
            fmt.format("\nif (typeof %1$s != 'undefined') {\n%2$s.add(%1$s);\n}", FacesUtils.getJsvar((FacesContext)context, (UIComponent)component), FacesUtils.getJsvar((FacesContext)context, (UIComponent)parent));
        }
        resource.addInitScript(buf.toString());
    }

    private static boolean isToolBarCombo(UIComponent component) {
        return component instanceof UICombo && component.getRendererType().equals("org.operamasks.faces.widget.ToolBarCombo");
    }

    private static boolean isToolBarButton(UIComponent component) {
        return component instanceof UICommand && component.getRendererType().equals("org.operamasks.faces.widget.ToolBarButton");
    }

    private static List<ToolBar> findExternalToolBar(UIComponent component, Class<? extends ToolBar> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqMap = context.getExternalContext().getRequestMap();
        Map toolbarCache = (Map)FacesUtils.createIfAbsent((Map)reqMap, (Object)(TOOLBAR_CACHE_EXTERNAL + type.getName()), HashMap.class);
        ArrayList<ToolBar> toolbars = (ArrayList<ToolBar>)toolbarCache.get(component);
        if (toolbars == null) {
            toolbars = new ArrayList<ToolBar>();
            HashSet<UIComponent> excluded = new HashSet<UIComponent>();
            excluded.add(component);
            Iterator it = FacesUtils.createChildrenIterator((UIComponent)FacesUtils.getViewRoot((UIComponent)component), (boolean)false, excluded);
            String id = component.getId();
            while (it.hasNext()) {
                ToolBar tb;
                UIComponent c = (UIComponent)it.next();
                if (!type.isAssignableFrom(c.getClass()) || !id.equals((tb = (ToolBar)c).getTarget())) continue;
                ToolBarHelper.adjustForId(id, c);
                toolbars.add(tb);
            }
            toolbarCache.put(component, toolbars);
        }
        return toolbars;
    }

    private static void adjustForId(String id, UIComponent component) {
        String forId;
        if (component instanceof UIPager && ((forId = (String)component.getAttributes().get("for")) == null || forId == "")) {
            component.getAttributes().put("for", id);
        }
    }

    public static List<UIPagingToolbar> findExternalPagingToolBar(UIComponent component) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map reqMap = context.getExternalContext().getRequestMap();
        Map toolbarCache = (Map)FacesUtils.createIfAbsent((Map)reqMap, (Object)TOOLBAR_CACHE_EXTERNALPAGING, HashMap.class);
        ArrayList<UIPagingToolbar> toolbars = (ArrayList<UIPagingToolbar>)toolbarCache.get(component);
        if (toolbars == null) {
            toolbars = new ArrayList<UIPagingToolbar>();
            HashSet<UIComponent> excluded = new HashSet<UIComponent>();
            excluded.add(component);
            Iterator it = FacesUtils.createChildrenIterator((UIComponent)FacesUtils.getViewRoot((UIComponent)component), (boolean)false, excluded);
            String id = component.getId();
            while (it.hasNext()) {
                UIPagingToolbar tb;
                UIComponent c = (UIComponent)it.next();
                if (!(c instanceof UIPagingToolbar) || !id.equals((tb = (UIPagingToolbar)c).getFor())) continue;
                toolbars.add(tb);
            }
            toolbarCache.put(component, toolbars);
        }
        return toolbars;
    }

    public static List<ToolBar> findInternalToolBar(UIComponent component, Class<? extends ToolBar> type, boolean standalone, boolean cache) {
        Map reqMap;
        FacesContext context = FacesContext.getCurrentInstance();
        List<ToolBar> toolbars = null;
        Map toolbarCache = null;
        if (cache && (toolbars = (List)(toolbarCache = (Map)FacesUtils.createIfAbsent((Map)(reqMap = context.getExternalContext().getRequestMap()), (Object)(TOOLBAR_CACHE_INTERNAL + type.getName()), HashMap.class)).get(component)) != null) {
            return toolbars;
        }
        Iterator it = FacesUtils.createChildrenIterator((UIComponent)component, (boolean)false);
        String id = component.getId();
        toolbars = new ArrayList<ToolBar>();
        while (it.hasNext()) {
            UIComponent c = (UIComponent)it.next();
            if (!type.isAssignableFrom(c.getClass())) continue;
            ToolBar tb = (ToolBar)c;
            String target = tb.getTarget();
            if (target == null && !standalone) {
                tb.setTarget(id);
            } else if (!id.equals(target)) continue;
            toolbars.add(tb);
        }
        if (cache) {
            toolbarCache.put(component, toolbars);
        }
        return toolbars;
    }

    public static List<ToolBar> findToolBar(UIComponent component, Class<? extends ToolBar> type, boolean standalone) {
        ArrayList<ToolBar> tb = new ArrayList<ToolBar>(ToolBarHelper.findInternalToolBar(component, type, standalone, true));
        tb.addAll(ToolBarHelper.findExternalToolBar(component, type));
        return tb;
    }

    public static <T extends ToolBar> String encodeToolBarExtConfig(FacesContext context, UIComponent component, Iterator<ToolBar> toolbars) {
        ToolBar toolbar;
        assert (toolbars != null);
        String tbPosition = ToolBarHelper.getToolBarPosition(component);
        StringBuilder script = new StringBuilder();
        if (toolbars.hasNext() && ((UIComponent)(toolbar = toolbars.next())).isRendered()) {
            if ("bottom".equals(tbPosition)) {
                script.append("bbar:" + toolbar.encodeAsItem(component));
            } else {
                script.append("tbar:" + toolbar.encodeAsItem(component));
            }
        }
        if ("both".equals(tbPosition) && toolbars.hasNext() && ((UIComponent)(toolbar = toolbars.next())).isRendered()) {
            if (script.length() > 0) {
                script.append(",");
            }
            script.append("bbar:" + toolbar.encodeAsItem(component));
        }
        return script.toString();
    }

    private static String getToolBarPosition(UIComponent component) {
        String tbPosition = (String)component.getAttributes().get("toolBarPosition");
        return tbPosition != null ? tbPosition : "top";
    }

    public static String encodeItemList(UIComponent toolbar) {
        StringBuilder buf = new StringBuilder();
        FacesContext context = FacesContext.getCurrentInstance();
        for (UIComponent child : toolbar.getChildren()) {
            Object renderer = ContainerRenderUtils.getRenderer((FacesContext)context, (UIComponent)child);
            if (!(renderer instanceof ToolBarItemRenderer)) continue;
            ToolBarItemRenderer itemRenderer = (ToolBarItemRenderer)renderer;
            if (buf.length() == 0) {
                buf.append("[");
            } else {
                buf.append(",");
            }
            buf.append(itemRenderer.getToolBarItemAddElement(context, child));
        }
        if (buf.length() > 0) {
            buf.append("]");
        }
        return buf.toString();
    }

    public static String encodeAddItemScript(FacesContext context, UIComponent component, String jsvar) {
        return ContainerRenderUtils.getItemAddScript((FacesContext)context, (UIComponent)component, (String)jsvar);
    }

    public static String encodeAddItemScript(FacesContext context, UIComponent component) {
        String jsvar = Aliases.getVar((String)FacesUtils.getJsvar((FacesContext)context, (UIComponent)component));
        return ToolBarHelper.encodeAddItemScript(context, component, jsvar);
    }

    public static String encodeItemInitScript(FacesContext context, UIComponent container, Class<? extends ToolBar> type, boolean standalone) {
        Iterator<ToolBar> toolbars = ToolBarHelper.getToolBarIterator(container, type, standalone);
        StringBuilder buf = new StringBuilder();
        Formatter fmt = new Formatter(buf);
        while (toolbars.hasNext()) {
            ToolBar toolBar = toolbars.next();
            if (((UIComponent)toolBar).isRendered()) {
                ContainerRenderUtils.encodeItemInitScript((FacesContext)context, (UIComponent)((UIComponent)toolBar), (Formatter)fmt);
                continue;
            }
            ContainerRenderUtils.ignoreItems((FacesContext)context, (UIComponent)((UIComponent)toolBar));
        }
        return buf.toString();
    }

    public static Iterator<ToolBar> getToolBarIterator(UIComponent container, Class<? extends ToolBar> type, boolean standalone) {
        return new ToolBarIterator(container, type, standalone);
    }

    public static UIComponent getForComponent(FacesContext context, UIComponent component, boolean cache) {
        return ToolBarHelper.getAssociatedComponent(context, component, cache, "for");
    }

    public static UIComponent getTargetComponent(FacesContext context, UIComponent component, boolean cache) {
        return ToolBarHelper.getAssociatedComponent(context, component, cache, "target");
    }

    private static UIComponent getAssociatedComponent(FacesContext context, UIComponent component, boolean cache, String keyAttribute) {
        String id = (String)component.getAttributes().get(keyAttribute);
        if (id == null) {
            return null;
        }
        UIComponent target = null;
        if (cache) {
            String key = TOOLBAR_CACHE_FOR_TARGET + keyAttribute;
            Map reqMap = context.getExternalContext().getRequestMap();
            Map forTargetCache = (Map)FacesUtils.createIfAbsent((Map)reqMap, (Object)key, HashMap.class);
            if (forTargetCache.containsKey(component)) {
                target = (UIComponent)forTargetCache.get(component);
            } else {
                target = FacesUtils.getForComponent((FacesContext)context, (String)id, (UIComponent)component);
                forTargetCache.put(component, target);
            }
        } else {
            target = FacesUtils.getForComponent((FacesContext)context, (String)id, (UIComponent)component);
        }
        return target;
    }

    public static UIComponent getParentCarrier(UIComponent component) {
        for (UIComponent c = component.getParent(); c != null; c = c.getParent()) {
            if (!(c instanceof ToolBarCarrier)) continue;
            return c;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ToolBarIterator
    implements Iterator<ToolBar> {
        private List<ToolBar> toolbars;
        private UIComponent container;
        private int index;
        private int selected;
        private int count;
        private boolean foundNext = false;

        public ToolBarIterator(UIComponent container, Class<? extends ToolBar> type, boolean standalone) {
            this.container = container;
            this.toolbars = ToolBarHelper.findToolBar(container, type, standalone);
            this.index = 0;
            this.selected = 0;
            this.refreshCount();
        }

        private void refreshCount() {
            this.count = this.toolbars.size();
            String tbPosition = (String)this.container.getAttributes().get("toolBarPosition");
            if (tbPosition == null) {
                tbPosition = "top";
            }
            if ("none".equals(tbPosition)) {
                this.count = 0;
            }
            if ("both".equals(tbPosition) && this.count > 1) {
                this.count = 2;
            } else if (this.count > 0) {
                this.count = 1;
            }
        }

        public void addList(List<ToolBar> list) {
            if (list != null) {
                this.toolbars.addAll(list);
                this.refreshCount();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.foundNext) {
                return true;
            }
            while (this.index < this.toolbars.size() && this.selected < this.count) {
                if (this.accepted(this.toolbars.get(this.index))) {
                    this.foundNext = true;
                    ++this.selected;
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        private boolean accepted(ToolBar toolBar) {
            return true;
        }

        @Override
        public ToolBar next() {
            if (this.foundNext) {
                this.foundNext = false;
                return this.toolbars.get(this.index++);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

