/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.widget.helper;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.operamasks.faces.component.tree.base.TreeDataProvider;
import org.operamasks.faces.component.tree.base.TreeDataProvider2;
import org.operamasks.faces.component.tree.base.TreeDataProvider3;
import org.operamasks.faces.component.tree.base.UITreeNodeBase;
import org.operamasks.faces.component.tree.impl.UITree;
import org.operamasks.faces.component.tree.impl.UITreeNode;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.render.resource.Aliases;

public class TreeRenderHelper {
    public static final String NODE_INDEX_KEY = "_nodeIndex";
    public static final String DELEGATE_KEY = "_delegate";
    public static final String TREE_NODE_BLANK_IMG_CLASS = "blank-image";

    public static UITree getTree(UITreeNodeBase node) {
        UITreeNodeBase tree = node;
        while (tree.getParent() != null) {
            if (!((tree = tree.getParent()) instanceof UITree)) continue;
            return (UITree)((Object)tree);
        }
        return null;
    }

    public static String createUniqueTreeNodeId(UITree tree) {
        FacesContext context = FacesContext.getCurrentInstance();
        return String.valueOf(tree.getId()) + "_" + TreeRenderHelper.getIndexParam(context, tree).toString();
    }

    private static Integer getIndexParam(FacesContext context, UITree tree) {
        String nodeIndexParam;
        Map sessionmap = context.getExternalContext().getSessionMap();
        if (sessionmap.get(nodeIndexParam = String.valueOf(tree.getClientId(context)) + "_" + NODE_INDEX_KEY) == null) {
            sessionmap.put(nodeIndexParam, 1);
            return 0;
        }
        int index = Integer.parseInt(sessionmap.get(nodeIndexParam).toString());
        sessionmap.put(nodeIndexParam, index + 1);
        return index;
    }

    public static void saveComponentTree(UITree tree) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent component = OMUtils.cloneComponent((UIComponent)tree, (boolean)true);
        Map sessionmap = context.getExternalContext().getSessionMap();
        sessionmap.put(String.valueOf(tree.getClientId(context)) + DELEGATE_KEY, component);
    }

    public static UITree loadComponentTree(String clientId) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext ectx = context.getExternalContext();
        Map sessionmap = ectx.getSessionMap();
        return (UITree)sessionmap.get(String.valueOf(clientId) + DELEGATE_KEY);
    }

    public static Object getLock() {
        FacesContext context = FacesContext.getCurrentInstance();
        Map sessionmap = context.getExternalContext().getSessionMap();
        Object lock = sessionmap.get("lock");
        if (lock == null) {
            lock = new Object();
            sessionmap.put("lock", lock);
        }
        return lock;
    }

    public static void buildNodesByCondition(UITree tree, TreeDataProvider dataProvider, UIComponent parent, Object parentUserData, Boolean expandAll) {
        Object[] children = dataProvider.getChildren(parentUserData);
        if (children == null) {
            return;
        }
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            Object child = objectArray[n2];
            UITreeNode newNode = new UITreeNode();
            newNode.setUpdateAble(true);
            if (dataProvider instanceof TreeDataProvider3) {
                String iconCls;
                id = ((TreeDataProvider3)dataProvider).getId(child);
                if (id != null) {
                    newNode.setId(id);
                } else {
                    newNode.setId(TreeRenderHelper.createUniqueTreeNodeId(tree));
                }
                String cls = ((TreeDataProvider3)dataProvider).getCls(child);
                if (cls != null) {
                    newNode.setCls(cls);
                }
                if ((iconCls = ((TreeDataProvider3)dataProvider).getIconCls(child)) != null) {
                    newNode.setIconCls(iconCls);
                }
                newNode.setDisabled(((TreeDataProvider3)dataProvider).isDisabled(child));
                newNode.setLeaf(((TreeDataProvider3)dataProvider).isLeaf(child));
                newNode.setSingleClickExpand(((TreeDataProvider3)dataProvider).isSingleClickExpand(child));
                newNode.setQtip(((TreeDataProvider3)dataProvider).getQtip(child));
            } else if (dataProvider instanceof TreeDataProvider2) {
                id = ((TreeDataProvider2)dataProvider).getId(child);
                if (id != null) {
                    newNode.setId(id);
                } else {
                    newNode.setId(TreeRenderHelper.createUniqueTreeNodeId(tree));
                }
            } else {
                newNode.setId(TreeRenderHelper.createUniqueTreeNodeId(tree));
                Boolean autoLeaf = tree.getAutoLeaf();
                if (Boolean.TRUE.equals(autoLeaf)) {
                    Object[] childChildren = dataProvider.getChildren(child);
                    if (childChildren == null || childChildren.length == 0) {
                        newNode.setLeaf(true);
                    } else {
                        newNode.setLeaf(false);
                    }
                } else {
                    newNode.setLeaf(false);
                }
            }
            newNode.setText(dataProvider.getText(child));
            String icon = dataProvider.getIcon(child);
            if (icon != null) {
                newNode.setIcon(icon);
            } else {
                newNode.setIconCls(TREE_NODE_BLANK_IMG_CLASS);
            }
            newNode.setChecked(dataProvider.isChecked(child));
            newNode.setExpanded(dataProvider.isExpanded(child));
            newNode.setCascade(dataProvider.isCascade(child));
            newNode.setHref(dataProvider.getHref(child));
            newNode.setHrefTarget(dataProvider.getHrefTarget(child));
            newNode.setUserData(child);
            if (parent instanceof UITree) {
                ((UITree)parent).add(newNode);
            }
            if (parent instanceof UITreeNode) {
                ((UITreeNode)parent).addWithoutScript(newNode);
            }
            if (expandAll.booleanValue()) {
                TreeRenderHelper.buildNodesByCondition(tree, dataProvider, (UIComponent)newNode, child, expandAll);
            }
            ++n2;
        }
    }

    public static UITree replaceRootTreeNode(UITree newTree, UITree oldTree) {
        oldTree.setValue(newTree.getValue());
        UITreeNode newRootNode = null;
        for (UIComponent child : newTree.getChildren()) {
            if (!(child instanceof UITreeNode)) continue;
            newRootNode = (UITreeNode)child;
            break;
        }
        if (newRootNode != null) {
            for (UIComponent child : oldTree.getChildren()) {
                if (!(child instanceof UITreeNode)) continue;
                oldTree.getChildren().remove(child);
                break;
            }
            oldTree.getChildren().add(newRootNode);
        }
        return oldTree;
    }

    public static String getTreeNodeConfig(UITreeNode node, Aliases.ConfigBuilder c) {
        Aliases alias = Aliases.getInstance();
        ExtConfig nodeConfig = new ExtConfig((UIComponent)node);
        nodeConfig.remove("checked");
        if (node.getChecked() != null) {
            if (Boolean.TRUE.equals(node.getChecked())) {
                nodeConfig.set("check", "checked");
            } else {
                nodeConfig.set("check", "unchecked");
            }
            UIComponent parent = node.getParent();
            if (parent == null || parent instanceof UITreeNode || parent instanceof UITree && !Boolean.FALSE.equals(((UITree)parent).getRootVisible())) {
                if (Boolean.TRUE.equals(node.getCascade())) {
                    nodeConfig.set("uiProvider", alias.alias("Ext.tree.CheckboxNodeUI"), true);
                } else {
                    nodeConfig.set("uiProvider", alias.alias("Ext.tree.SimpleCheckboxNodeUI"), true);
                }
            }
        }
        if (node.getIcon() == null) {
            nodeConfig.set("iconCls", TREE_NODE_BLANK_IMG_CLASS);
        }
        return nodeConfig.toScript(c);
    }
}

