/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.operamasks.faces.component.form.impl.UIField;
import org.operamasks.faces.component.grid.impl.UIEditDataGrid;
import org.operamasks.faces.component.html.HtmlPage;
import org.operamasks.faces.component.toolbar.ToolBar;
import org.operamasks.faces.component.widget.ExtConfig;
import org.operamasks.faces.component.widget.UIForm;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.org.json.simple.JSONObject;
import org.operamasks.org.json.simple.JSONValue;

public final class CompRendererUtils {
    private static final Logger log = LoggerUtil.getLogger((String)"org.operamasks.faces.view");

    public static boolean needsDecode(UIComponent component) {
        return true;
    }

    public static Boolean isClientValidateEnabled(UIField field) {
        UIForm form = CompRendererUtils.getParentUIForm((UIComponent)field);
        if (Boolean.TRUE.equals(field.getClientValidate())) {
            return true;
        }
        if (Boolean.FALSE.equals(field.getClientValidate())) {
            return false;
        }
        if (form != null && Boolean.FALSE.equals(form.getClientValidate())) {
            return false;
        }
        if (field.getValidateEvents() != null && field.getValidateEvents().length() > 0) {
            return true;
        }
        if (form != null && Boolean.TRUE.equals(form.getClientValidate())) {
            return true;
        }
        return null;
    }

    public static UIForm getParentUIForm(UIComponent component) {
        while (component != null) {
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static void mergeUserExtConfig(UIComponent component, ExtConfig config) {
        ExtConfig initConfig = null;
        Object icObject = component.getAttributes().get("initConfig");
        if (icObject instanceof String) {
            initConfig = new ExtConfig();
            try {
                JSONObject jsono = (JSONObject)JSONValue.parse((String)((String)icObject));
                if (jsono == null) {
                    throw new FacesException("Can't parse initConfig: " + icObject);
                }
                for (Object entryObj : jsono.entrySet()) {
                    String varPrefix;
                    String svalue;
                    Map.Entry entry = (Map.Entry)entryObj;
                    Object ckey = entry.getKey();
                    Object cvalue = entry.getValue();
                    if (cvalue == null) {
                        initConfig.set(ckey.toString(), null, false, true);
                        continue;
                    }
                    if (cvalue instanceof String && (svalue = (String)cvalue).startsWith(varPrefix = "var::")) {
                        String pureValue = svalue.substring(varPrefix.length());
                        initConfig.set(ckey.toString(), pureValue, true);
                        continue;
                    }
                    initConfig.set(ckey.toString(), cvalue);
                }
            }
            catch (Error err) {
                initConfig.setInitConfigText((String)icObject);
            }
        } else if (icObject instanceof ExtConfig) {
            initConfig = (ExtConfig)component.getAttributes().get("initConfig");
        }
        if (initConfig != null) {
            config.merge(initConfig);
        }
    }

    public static boolean isRepaintable(UIComponent component) {
        UIComponent p = component.getParent();
        while (p != null && !(p instanceof ToolBar) && !(p instanceof UIEditDataGrid)) {
            p = p.getParent();
        }
        if (p != null) {
            log.fine("Skipped repainting of field [" + component.getId() + "] which is in a toolbar.");
            return false;
        }
        return true;
    }

    public static boolean hasParentPage(UIComponent component) {
        UIComponent parent = component.getParent();
        boolean hasParentPage = false;
        while (parent != null) {
            if (parent instanceof HtmlPage) {
                hasParentPage = true;
                break;
            }
            parent = parent.getParent();
        }
        return hasParentPage;
    }
}

