/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.util.FacesUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentUtils {
    public static long decodeCapacityString(String maxSizeString) {
        char unitChar;
        if (maxSizeString.length() <= 1) {
            ComponentUtils.throwException(maxSizeString);
        }
        if ((unitChar = maxSizeString.charAt(maxSizeString.length() - 1)) != 'm' && unitChar != 'M' && unitChar != 'k' && unitChar != 'K' && unitChar != 'b' && unitChar != 'B') {
            ComponentUtils.throwException(maxSizeString);
        }
        long size = -1L;
        try {
            size = Long.parseLong(maxSizeString.substring(0, maxSizeString.length() - 1));
        }
        catch (NumberFormatException e) {
            ComponentUtils.throwException(maxSizeString);
        }
        long factor = unitChar == 'm' || unitChar == 'M' ? 0x100000L : (unitChar == 'k' || unitChar == 'K' ? 1024L : 1L);
        return size * factor;
    }

    private static void throwException(String maxSizeString) {
        throw new FacesException((Throwable)new IllegalArgumentException("Illegal maxSize format: " + maxSizeString + ". You can set maxSize in human readable format(e.g., 4096B, 10K, 234M"));
    }

    public static <T> List<T> findAssociatedComponents(String targetId, UIComponent root, Class<T> type, String keyAttribute, Set<UIComponent> excluded) {
        assert (targetId != null && keyAttribute != null);
        if (root == null) {
            root = FacesContext.getCurrentInstance().getViewRoot();
        }
        ArrayList<UIComponent> components = new ArrayList<UIComponent>();
        Iterator kids = FacesUtils.createChildrenIterator((UIComponent)root, (boolean)true, excluded);
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            if (!type.isInstance(kid) || !kid.isRendered() || !targetId.equals(kid.getAttributes().get(keyAttribute))) continue;
            components.add(kid);
        }
        return components;
    }
}

