/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.util;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.component.ajax.AjaxProgress;
import org.operamasks.faces.component.ajax.ProgressState;
import org.operamasks.faces.component.ajax.ProgressStatus;
import org.operamasks.faces.component.widget.UIFileUploadProgress;
import org.operamasks.faces.component.widget.UIProgressBar;
import org.operamasks.faces.component.widget.fileupload.UploadingMediator;
import org.operamasks.faces.component.widget.fileupload.UploadingStatus;
import org.operamasks.faces.config.ManagedBeanConfig;
import org.operamasks.faces.util.UIComponentFactory;
import org.operamasks.resources.Resources;

public class FileUploadUtils {
    private static final String KEY_PROGRESS_ID = "org.operamasks.faces.webapp.widget.FileUploadProgressTag.progressId";

    public static void decorateFileUploadProgress(FacesContext context, UIFileUploadProgress fileUploadProgress) {
        UIComponentFactory factory = new UIComponentFactory();
        HtmlOutputText output = (HtmlOutputText)factory.createComponent(context, "javax.faces.HtmlOutputText");
        UIProgressBar progressBar = (UIProgressBar)factory.createComponent(context, "org.operamasks.faces.component.widget.UIProgressBar");
        AjaxProgress progress = (AjaxProgress)factory.createComponent(context, "org.operamasks.faces.component.ajax.AjaxProgress");
        progress.setFor(progressBar.getId() + " " + output.getId());
        progress.setAction(context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), "#{_" + progress.getId() + "_bean.processAction}", Void.class, new Class[]{ProgressStatus.class}));
        if (fileUploadProgress.getInterval() > 1) {
            progress.setInterval(fileUploadProgress.getInterval());
        } else {
            progress.setInterval(1);
        }
        if (fileUploadProgress.getChildCount() == 0) {
            fileUploadProgress.getChildren().add(progressBar);
            fileUploadProgress.getChildren().add(output);
            fileUploadProgress.getChildren().add(progress);
        }
        ManagedBeanConfig mb = new ManagedBeanConfig();
        mb.setManagedBeanName("_" + progress.getId() + "_bean");
        mb.setManagedBeanClass(ProgressMonitor.class.getName());
        mb.setManagedBeanScope(ManagedBeanScope.REQUEST);
        ManagedBeanContainer.getInstance().addBeanFactory(mb);
        context.getExternalContext().getRequestMap().put(KEY_PROGRESS_ID, fileUploadProgress.getId());
    }

    public static class ProgressMonitor {
        private static final int WAITTING_FILEUPLOADER_INIT_MAX_RETRY = 20;
        private static final String REQUEST_IDENTIFIER_KEY = "_request_identifier";

        public void processAction(ProgressStatus status) {
            FacesContext context = FacesContext.getCurrentInstance();
            String progressId = (String)context.getExternalContext().getRequestMap().get(FileUploadUtils.KEY_PROGRESS_ID);
            if (progressId == null) {
                throw new FacesException("Can't retrieve progress id from request.");
            }
            UIFileUploadProgress fileUploadProgress = this.findFileUploadProgress(context, progressId);
            if (fileUploadProgress == null) {
                throw new FacesException("UIFileUploadProgress not found.");
            }
            String identifierStr = (String)context.getExternalContext().getRequestParameterMap().get(REQUEST_IDENTIFIER_KEY);
            Long identifier = null;
            try {
                identifier = Long.valueOf(identifierStr);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Illegal request identifier.", ex);
            }
            UploadingMediator mediator = UploadingMediator.getInstance();
            boolean inited = false;
            for (int i = 0; i < 20; ++i) {
                Long mark = mediator.getProgressorMark(context, true);
                if (mark != null && mark.equals(identifier)) {
                    inited = true;
                    break;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (!inited) {
                status.setMessage("Waiting for fileuploader initialization timeout.");
                status.setPercentage(100);
                status.setState(ProgressState.COMPLETED);
                return;
            }
            if (status.getAction().ordinal() == 0) {
                this.setStatusToStart(fileUploadProgress, status);
            } else if (status.getAction().ordinal() == 4) {
                if (this.isErrorStatus()) {
                    this.setStatusToError(fileUploadProgress, status);
                    return;
                }
                if (this.isWaittingStatus()) {
                    this.setWaittingStatus(status);
                    return;
                }
                if (this.isCompletedStatus()) {
                    this.setCompletedStatus(fileUploadProgress, status);
                    return;
                }
                this.setRunningStatus(fileUploadProgress, status);
            } else if (this.isStoppedStatus(status)) {
                this.setStoppedStatus(status);
            }
        }

        private void setStoppedStatus(ProgressStatus status) {
            status.setState(ProgressState.STOPPED);
        }

        private boolean isStoppedStatus(ProgressStatus status) {
            return status.getAction().ordinal() == 1;
        }

        private boolean isWaittingStatus() {
            return this.getUploadingStatus().getContentLength() == null || this.getUploadingStatus().getContentLength() == 0L;
        }

        private boolean isCompletedStatus() {
            if (this.getUploadingStatus().getContentLength().equals(this.getUploadingStatus().getBytesRead())) {
                UploadingMediator mediator = UploadingMediator.getInstance();
                FacesContext context = FacesContext.getCurrentInstance();
                String identifierStr = (String)context.getExternalContext().getRequestParameterMap().get(REQUEST_IDENTIFIER_KEY);
                Long identifier = null;
                try {
                    identifier = Long.valueOf(identifierStr);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Illegal request identifier.", ex);
                }
                Long mark = mediator.getProgressorMark(context, false);
                return mark != null && mark.equals(identifier);
            }
            return false;
        }

        private void setRunningStatus(UIFileUploadProgress progress, ProgressStatus status) {
            status.setPercentage(this.getPercentage());
            status.setMessage(this.getMessage(progress.getUploadingMessage(), "UI_FILE_UPLOAD_UPLOADING_MESSAGE", this.getTotal(), this.getReadBytes(), this.getPercentage()));
            this.setWaittingStatus(status);
        }

        private void setCompletedStatus(UIFileUploadProgress progress, ProgressStatus status) {
            status.setMessage(this.getMessage(progress.getCompleteMessage(), "UI_FILE_UPLOAD_COMPLETE_MESSAGE", this.getTotal()));
            status.setPercentage(100);
            status.setState(ProgressState.COMPLETED);
        }

        private void setWaittingStatus(ProgressStatus status) {
            status.setState(ProgressState.RUNNING);
        }

        private boolean isErrorStatus() {
            return this.getUploadingStatus().getError() != null;
        }

        private UploadingStatus getUploadingStatus() {
            return UploadingMediator.getInstance().getUploadingStatus(FacesContext.getCurrentInstance());
        }

        private void setStatusToError(UIFileUploadProgress progress, ProgressStatus status) {
            status.setMessage(this.getMessage(progress.getErrorMessage(), "UI_FILE_UPLOAD_ERROR_MESSAGE", this.getUploadingStatus().getError().getCause().getMessage()));
            status.setState(ProgressState.COMPLETED);
        }

        private void setStatusToStart(UIFileUploadProgress progress, ProgressStatus status) {
            status.setMessage(this.getMessage(progress.getStartMessage(), "UI_FILE_UPLOAD_START_MESSAGE", new Object[0]));
            status.setPercentage(0);
            status.setState(ProgressState.RUNNING);
        }

        private String getMessage(String userMessage, String resourceKey, Object ... params) {
            if (userMessage != null) {
                return this.replaceVariableHolders(userMessage);
            }
            return Resources._T((String)resourceKey, (Object[])params);
        }

        private String replaceVariableHolders(String message) {
            if (message == null || message.equals("")) {
                return message;
            }
            message = message.replace("{total}", Long.toString(this.getTotal()));
            message = message.replace("{readBytes}", Long.toString(this.getReadBytes()));
            message = message.replace("{percentage}", Long.toString(this.getPercentage()));
            message = this.getUploadingStatus().getError() != null && this.getUploadingStatus().getError().getCause() != null && this.getUploadingStatus().getError().getCause().getMessage() != null ? message.replace("{error}", this.getUploadingStatus().getError().getCause().getMessage()) : message.replace("{error}", "Unknown error");
            return message;
        }

        private UIFileUploadProgress findFileUploadProgress(FacesContext context, String progressId) {
            return this.findFileUploadProgress(context, progressId, (UIComponent)context.getViewRoot());
        }

        private UIFileUploadProgress findFileUploadProgress(FacesContext context, String progressId, UIComponent component) {
            for (UIComponent child : component.getChildren()) {
                if (child.getId().equals(progressId)) {
                    return (UIFileUploadProgress)child;
                }
                UIFileUploadProgress fileUploadProgress = this.findFileUploadProgress(context, progressId, child);
                if (fileUploadProgress == null) continue;
                return fileUploadProgress;
            }
            return null;
        }

        private long getReadBytes() {
            return this.bytesToKilo(this.getUploadingStatus().getBytesRead());
        }

        private long getTotal() {
            return this.bytesToKilo(this.getUploadingStatus().getContentLength());
        }

        private int getPercentage() {
            if (this.getUploadingStatus().getContentLength() == 0L) {
                return 0;
            }
            return (int)(100L * this.getUploadingStatus().getBytesRead() / this.getUploadingStatus().getContentLength());
        }

        public long bytesToKilo(long bytes) {
            return bytes / 1024L + (long)(bytes % 1024L > 0L ? 1 : 0);
        }
    }
}

