﻿Ext.namespace("Ext.om");

Ext.om.DatetimePicker = function(config){
    Ext.om.DatetimePicker.superclass.constructor.call(this, config);
    this.hour_step = (config && config.hourStep) ? config.hourStep : 1;
    this.minute_step = (config && config.minuteStep) ? config.minuteStep : 5;
    this.hr_up_label = this.hr_up.replace("{0}", this.hour_step);
    this.hr_down_label = this.hr_down.replace("{0}", this.hour_step);
    this.min_up_label = this.min_up.replace("{0}", this.minute_step);
    this.min_down_label = this.min_down.replace("{0}", this.minute_step);
    this.limitedAlign = (config && config.limitedAlign) ? config.limitedAlign : false;
    if (config && config.hourFilter)
    	this.hourFilter = config.hourFilter;
    if (config && config.minuteFilter)
    	this.minuteFilter = config.minuteFilter;
};

Ext.extend(Ext.om.DatetimePicker, Ext.DatePicker, {
    hour_label : '时：',
    min_label : '分：',
    hr_up : '加{0}小时',
    hr_down : '减{0}小时',
    min_up : '加{0}分钟',
    min_down : '减{0}分钟',
    
    _adjust:function(n, step, cap){
        var mod = n % step,
            res = n - mod + ((!this.limitedAlign && mod > step / 2) ? step : 0);
        if (res > cap) res = cap - cap % step;
        return res;
    },
      
    selectToday : function(){
        this.setValue(new Date().clearTime());
        var val1 = this.value;
        val1.setHours(this.theHours);
        val1.setMinutes(this.theMinutes);
        this.fireEvent("select", this, val1);
    },
    handleDateClick : function(e, t){
        e.stopEvent();
        if(t.dateValue && !Ext.fly(t.parentNode).hasClass("x-date-disabled")){
            this.setValue(new Date(t.dateValue));
            var val1 = this.value;
            val1.setHours(this.theHours);
            val1.setMinutes(this.theMinutes);
            this.fireEvent("select", this, val1);
        }
    },
    _incHour : function() {
    	var hour = this.theHours,
    	    secondPass = false,
    	    passed = false;
    	do {
    	   hour += this.hour_step;
    	   if (hour > 23) {
    		   hour = 0;
    		   secondPass = true;
    	   }
    	   passed = !this.hourFilter || this.hourFilter(hour, this.theMinutes);
    	} while (!passed && (!secondPass || hour < this.theHours));
    	if (passed) {
    		this.theHours = hour;
    	}
    },
    _decHour : function() {
    	var hour = this.theHours,
    	    secondPass = false,
    	    passed = false;
    	do {
    	   hour -= this.hour_step;
    	   if (hour < 0) {
    		   hour = this._adjust(23, this.hour_step, 23);
    		   secondPass = true;
    	   }
    	   passed = !this.hourFilter || this.hourFilter(hour, this.theMinutes);
    	} while (!passed && (!secondPass || hour > this.theHours));
    	if (passed) {
    		this.theHours = hour;
    	}
    },
    _incMin : function() {
    	var min = this.theMinutes,
    	    secondPass = false,
    	    passed = false;
    	do {
    	   min += this.minute_step;
    	   if (min > 59) {
    		   min = 0;
    		   secondPass = true;
    	   }
    	   passed = !this.minuteFilter || this.minuteFilter(min, this.theHours);
    	} while (!passed && (!secondPass || min < this.theMinutes));
    	if (passed) {
    		this.theMinutes = min;
    	}
    },
    _decMin : function() {
    	var min = this.theMinutes,
    	    secondPass = false,
    	    passed = false;
    	do {
    	   min -= this.minute_step;
    	   if (min < 0) {
    		   min = this._adjust(59, this.minute_step, 59);
    		   secondPass = true;
    	   }
    	   passed = !this.minuteFilter || this.minuteFilter(min, this.theHours);
    	} while (!passed && (!secondPass || min > this.theMinutes));
    	if (passed) {
    		this.theMinutes = min;
    	}
    },
     onRender : function(container, position){
		var that = this;
        var m = [
             '<table cellspacing="0">',
                '<tr><td colspan="3"><table cellspacing="0" width="100%"><tr><td class="x-date-left"><a href="#" title="', this.prevText ,'">*</a></td><td class="x-date-middle" align="center"></td><td class="x-date-right"><a href="#" title="', this.nextText ,'">*</a></td></tr></table></td></tr>',
                '<tr><td colspan="3"><table class="x-date-inner" cellspacing="0"><thead><tr>'],
        dn = this.dayNames;
        for(var i = 0; i < 7; i++){
            var d = this.startDay+i;
            if(d > 6){
                d = d-7;
            }
            m.push("<th><span>", dn[d].substr(0,1), "</span></th>");
        }
        m[m.length] = "</tr></thead><tbody><tr>";
        for(i = 0; i < 42; i++) {
            if(i % 7 === 0 && i !== 0){
                m[m.length] = "</tr><tr>";
            }
            m[m.length] = '<td><a href="#" hidefocus="on" class="x-date-date" tabIndex="1"><em><span></span></em></a></td>';
        }

        m[m.length] = '</tr></tbody></table></td></tr><tr><td class="minutecss"><table cellspacing="0" ><tr>';
        m.push('<td class="y-hour-label" style="font-size:12px;">',this.hour_label,'</td><td class="y-hour-left"><a href="#" title="', this.hr_down_label ,'"> </a></td><td class="y-hour-middle" align="center"><input maxLength="2" style="width:19px;border:none;font-size:12px;color:#2D6299;font-weight:bold;background-color:transparent;text-align:center;"></td><td class="y-hour-right"><a href="#" title="' , this.hr_up_label ,'"> </a></td>');
        m.push('<td class="y-minute-label" style="font-size:12px;">',this.min_label, '<td class="y-minute-left"><a href="#" title="',this.min_down_label,'"> </a></td><td class="y-minute-middle" align="center"><input maxLength="2" style="width:19px;border:none;font-size:12px;color:#2D6299;font-weight:bold;background-color:transparent;text-align:center;"></td><td class="y-minute-right"><a href="#" title="',this.min_up_label,'"> </a></td>');
        m[m.length] = '</tr></table></td><td  colspan="2" class="x-date-bottom" align="center"></td></tr></table><div class="x-date-mp"></div>';

        var el = document.createElement("div");
        el.className = "x-date-picker";
        el.innerHTML = m.join("");

        container.dom.insertBefore(el, position);

        this.el = Ext.get(el);
        this.eventEl = Ext.get(el.firstChild);

        new Ext.util.ClickRepeater(this.el.child("td.x-date-left a"), {
            handler: this.showPrevMonth,
            scope: this,
            preventDefault:true,
            stopDefault:true
        });

        new Ext.util.ClickRepeater(this.el.child("td.x-date-right a"), {
            handler: this.showNextMonth,
            scope: this,
            preventDefault:true,
            stopDefault:true
        });
        new Ext.util.ClickRepeater(this.el.child("td.y-hour-left a"), {
                     handler: function(){
                             this._decHour();
                             var txt = '';
                             if(this.theHours<10){
                                 txt='0'+this.theHours;
                             }
                             else{
                                 txt= this.theHours;
                             }
							 this.hourLabel.value = txt;
                     }.createDelegate(this), 
                     scope: this
                 });
        new Ext.util.ClickRepeater(this.el.child("td.y-hour-right a"), {
                     handler: function(){
                         this._incHour();
                         var txt = '';
                         if(this.theHours<10){
                             txt='0'+this.theHours;
                         }
                         else{
                             txt= this.theHours;
                         }
                         this.hourLabel.value = txt;
                     }.createDelegate(this), 
                     scope: this
                 });
        new Ext.util.ClickRepeater(this.el.child("td.y-minute-left a"), {
                     handler: function(){
                             this._decMin();
                             var txt = '';
                             if(this.theMinutes<10){
                                 txt='0'+this.theMinutes;
                             }
                             else{
                                 txt= this.theMinutes;
                             }
                             this.minuteLabel.value = txt;
                             
                     }.createDelegate(this), 
                     scope: this
                 });
        new Ext.util.ClickRepeater(this.el.child("td.y-minute-right a"), {
                     handler: function(){
                         this._incMin();
                         var txt = '';
                         if(this.theMinutes<10){
                             txt='0'+this.theMinutes;
                         }
                         else{
                             txt= this.theMinutes;
                         }    
                         this.minuteLabel.value = txt;
                     }.createDelegate(this), 
                     scope: this
                 });

        this.eventEl.on("mousewheel", this.handleMouseWheel,  this);

        this.monthPicker = this.el.down('div.x-date-mp');
        this.monthPicker.enableDisplayMode('block');
        
        new Ext.KeyNav(this.eventEl, {
            "left" : function(e){
                e.ctrlKey ?
                    this.showPrevMonth() :
                    this.update(this.activeDate.add("d", -1));
            },

            "right" : function(e){
                e.ctrlKey ?
                    this.showNextMonth() :
                    this.update(this.activeDate.add("d", 1));
            },

            "up" : function(e){
                e.ctrlKey ?
                    this.showNextYear() :
                    this.update(this.activeDate.add("d", -7));
            },

            "down" : function(e){
                e.ctrlKey ?
                    this.showPrevYear() :
                    this.update(this.activeDate.add("d", 7));
            },

            "pageUp" : function(e){
                this.showNextMonth();
            },

            "pageDown" : function(e){
                this.showPrevMonth();
            },

            "enter" : function(e){
                e.stopPropagation();
                return true;
            },

            scope : this
        });

        this.eventEl.on("click", this.handleDateClick,  this, {delegate: "a.x-date-date"});

        this.eventEl.addKeyListener(Ext.EventObject.SPACE, this.selectToday,  this);

        this.el.unselectable();
        
        this.cells = this.el.select("table.x-date-inner tbody td");
        this.textNodes = this.el.query("table.x-date-inner tbody span");

        this.mbtn = new Ext.Button({
            text: "*",
            tooltip: this.monthYearText,
            renderTo: this.el.child("td.x-date-middle", true)
        });

        this.mbtn.on('click', this.showMonthPicker, this);
        this.mbtn.el.child(this.mbtn.menuClassTarget).addClass("x-btn-with-menu");

        var dt1 = new Date(),
            txt = '';
        this.hourLabel = this.el.child("td.y-hour-middle").first().dom;
		this.hourLabel.onfocus = function () {
			this.style.backgroundColor = "";
			this.style.border = "1px solid";
		}
		this.hourLabel.onblur = function () {
			this.style.backgroundColor = "transparent";
			this.style.border = "none";
		}
		this.hourLabel.onchange = function () {
			var v = this.value;
			if (parseInt(v) + "" == v || "0" + parseInt(v) == v) {
				v = parseInt(v);
				if (v >=0 && v <= 23) {
					if (!that.hourFilter || that.hourFilter(v, that.theMinutes)) {
						that.theHours = v;
					}
				}
			}
			if(that.theHours<10){
				this.value='0'+that.theHours;
			}
			else{
				this.value = that.theHours;
			}
		}
        this.theHours = this._adjust(dt1.getHours(), this.hour_step, 23);
        if(this.theHours<10){
            txt='0'+this.theHours;
        }
        else{
            txt= this.theHours;
        }    
        this.hourLabel.value = txt;

        this.minuteLabel = this.el.child("td.y-minute-middle").first().dom;
		this.minuteLabel.onfocus = function () {
			this.style.backgroundColor = "";
			this.style.border = "1px solid";
		}
		this.minuteLabel.onblur = function () {
			this.style.backgroundColor = "transparent";
			this.style.border = "none";
		}
		this.minuteLabel.onchange = function () {
			var v = this.value;
			if (parseInt(v) + "" == v || "0" + parseInt(v) == v) {
				v = parseInt(v);
				if (v >=0 && v <= 59) {
					if (!that.minuteFilter || that.minuteFilter(min, that.theHours)) {
						that.theMinutes = v;
					}
				}
			}
			if(that.theMinutes<10){
				this.value='0'+that.theMinutes;
			}
			else{
				this.value = that.theMinutes;
			}
		}
        this.theMinutes = this._adjust(dt1.getMinutes(), this.minute_step, 59);
        if(this.theMinutes<10){
            txt='0'+this.theMinutes;
        }
        else{
            txt= this.theMinutes;
        }    
        this.minuteLabel.value = txt;

        var today = (new Date()).dateFormat(this.format);
        new Ext.Button({
            renderTo: this.el.child("td.x-date-bottom", true),
            text: String.format(this.todayText, today),
            tooltip: String.format(this.todayTip, today),
            handler: this.selectToday,
            scope: this
        });
        
        if(Ext.isIE){
            this.el.repaint();
        }
        this.update(this.value);
    },

    /**
    * Method Name: update
    */
    update : function(date){
        var vd = this.activeDate;
        this.activeDate = date;
        if(vd && this.el){
            var t = date.getTime();
            if(vd.getMonth() == date.getMonth() && vd.getFullYear() == date.getFullYear()){
                this.cells.removeClass("x-date-selected");
                this.cells.each(function(c){
                   if(c.dom.firstChild.dateValue == t){
                       c.addClass("x-date-selected");
                       setTimeout(function(){
                            try{c.dom.firstChild.focus();}catch(e){}
                       }, 50);
                       return false;
                   }
                });
                return;
            }
        }
        var days = date.getDaysInMonth(),
            firstOfMonth = date.getFirstDateOfMonth(),
            startingPos = firstOfMonth.getDay()-this.startDay;

        if(startingPos <= this.startDay){
            startingPos += 7;
        }

        var pm = date.add("mo", -1),
            prevStart = pm.getDaysInMonth()-startingPos,

            cells = this.cells.elements,
            textEls = this.textNodes;
        days += startingPos;

        // convert everything to numbers so it's fast
        var d = (new Date(pm.getFullYear(), pm.getMonth(), prevStart)).clearTime(),
            today = new Date().clearTime().getTime(),
            sel = date.clearTime().getTime(),
            min = this.minDate ? this.minDate.clearTime() : Number.NEGATIVE_INFINITY,
            max = this.maxDate ? this.maxDate.clearTime() : Number.POSITIVE_INFINITY,
            ddMatch = this.disabledDatesRE,
            ddText = this.disabledDatesText,
            ddays = this.disabledDays ? this.disabledDays.join("") : false,
            ddaysText = this.disabledDaysText,
            format = this.format;

        var setCellClass = function(cal, cell){
            cell.title = "";
            var t = d.getTime();
            cell.firstChild.dateValue = t;
            if(t == today){
                cell.className += " x-date-today";
                cell.title = cal.todayText;
            }
            if(t == sel){
                cell.className += " x-date-selected";
                setTimeout(function(){
                    try{cell.firstChild.focus();}catch(e){}
                }, 50);
            }
            // disabling
            if(t < min) {
                cell.className = " x-date-disabled";
                cell.title = cal.minText;
                return;
            }
            if(t > max) {
                cell.className = " x-date-disabled";
                cell.title = cal.maxText;
                return;
            }
            if(ddays){
                if(ddays.indexOf(d.getDay()) != -1){
                    cell.title = ddaysText;
                    cell.className = " x-date-disabled";
                }
            }
            if(ddMatch && format){
                var fvalue = d.dateFormat(format);
                if(ddMatch.test(fvalue)){
                    cell.title = ddText.replace("%0", fvalue);
                    cell.className = " x-date-disabled";
                }
            }
        };

        var i = 0;
        for(; i < startingPos; i++) {
            textEls[i].innerHTML = (++prevStart);
            d.setDate(d.getDate()+1);
            cells[i].className = "x-date-prevday";
            setCellClass(this, cells[i]);
        }
        for(; i < days; i++){
            intDay = i - startingPos + 1;
            textEls[i].innerHTML = (intDay);
            d.setDate(d.getDate()+1);
            cells[i].className = "x-date-active";
            setCellClass(this, cells[i]);
        }
        var extraDays = 0;
        for(; i < 42; i++) {
             textEls[i].innerHTML = (++extraDays);
             d.setDate(d.getDate()+1);
             cells[i].className = "x-date-nextday";
             setCellClass(this, cells[i]);
        }

        this.mbtn.setText(this.monthNames[date.getMonth()] + " " + date.getFullYear());

        if(this.theHours<10){
            txt='0'+this.theHours;
        }
        else{
            txt= this.theHours;
        }
        this.hourLabel.value = txt;

        if(this.theMinutes<10){
            txt='0'+this.theMinutes;
        }
        else{
            txt= this.theMinutes;
        }    
        this.minuteLabel.value = txt;

        if(!this.internalRender){
            var main = this.el.dom.firstChild,
                w = main.offsetWidth;
            this.el.setWidth(w + this.el.getBorderWidth("lr"));
            Ext.fly(main).setWidth(w);
            this.internalRender = true;
            // opera does not respect the auto grow header center column
            // then, after it gets a width opera refuses to recalculate
            // without a second pass
            if(Ext.isOpera && !this.secondPass){
                main.rows[0].cells[1].style.width = (w - (main.rows[0].cells[0].offsetWidth+main.rows[0].cells[2].offsetWidth)) + "px";
                this.secondPass = true;
                this.update.defer(10, this, [date]);
            }
        }
    },
    
    /***** Public Instance Variables *****/
    
    /**
    * Variable Name: nextYearText, prevYearText
    * Description: Hover text for the previous year and next year arrow changers
    * Default: as shown
    * Type: string
    */
    nextYearText: 'Next Year (Control+Up)',
    prevYearText: 'Previous Year (Control+Down)'
});


/** Class Name: DatetimeItem
 * Inherits From: Ext.menu.Adapter
 */
Ext.om.DatetimeItem = function(config){
    Ext.om.DatetimeItem.superclass.constructor.call(this, new Ext.om.DatetimePicker(config), config);
    this.picker = this.component;
    this.addEvents({select: true});

    this.picker.on("render", function(picker){
        picker.getEl().swallowEvent("click");
        picker.container.addClass("x-menu-date-item");
    });

    this.picker.on("select", this.onSelect, this);
};

Ext.extend(Ext.om.DatetimeItem, Ext.menu.Adapter, {
    onSelect : function(picker, date){
        this.fireEvent("select", this, date, picker);
        Ext.om.DatetimeItem.superclass.handleClick.call(this);
    }
});


/** Class Name: DatetimeMenu
 * Inherits From: Ext.menu.Menu
 */
Ext.om.DatetimeMenu = function(config){
    Ext.om.DatetimeMenu.superclass.constructor.call(this, config);
    this.plain = true;
    var di = new Ext.om.DatetimeItem(config);
    this.add(di);
    this.picker = di.picker;
    this.relayEvents(di, ["select"]);
};
Ext.extend(Ext.om.DatetimeMenu,Ext.menu.Menu,{
	render : function(){
		Ext.om.DatetimeMenu.superclass.render.call(this);
		if(Ext.isGecko){
			this.picker.el.dom.childNodes[0].style.width = '200px';
			this.picker.el.dom.style.width = '200px';
		}
	}
});