if(Ext && Ext.form && Ext.form.Field){ 
	Ext.override(Ext.form.Field, {
	         fireKey : function(e) {
	             if(((Ext.isIE && e.type == 'keydown') || e.type == 'keypress') && e.isSpecialKey()) {
	                 this.fireEvent('specialkey', this, e);
	             }
	             else {
	                 this.fireEvent(e.type, this, e);
	             }
	         },
	         initEvents : function() {
	             this.el.on("focus", this.onFocus,  this);
	             this.el.on("blur", this.onBlur,  this);
	             this.el.on("keydown", this.fireKey, this);
	             this.el.on("keypress", this.fireKey, this);
	             this.el.on("keyup", this.fireKey, this);
	             // this.el.on("change", this.onChange, this);
	             // reference to original value for reset
	             this.originalValue = this.getValue();
	         },
	         setValue : function(v){
	    		 this.value = v;
	    		 if(this.rendered){
	      			this.el.dom.value = (v === null || v === undefined ? '' : v);
	     		 }
	         }
	         /*,
	         onChange : function() {
	            var v = this.el.getValue();
	            this.setValue(v);
	            this.fireEvent('change', this, v, this.startValue);
	         }
	         */
	});
}

if(Ext && Ext.form && Ext.form.HtmlEditor){ 
	Ext.form.HtmlEditor.prototype.validateValue = function(value) {
		if(typeof this.validator == "function"){
			var msg = this.validator(value);
			if(msg !== true){
	            this.markInvalid(msg);
	            return false;
	        }
	    }
	    return true;
	};
}

if(Ext && Ext.form && Ext.form.Checkbox){ 
	Ext.form.Checkbox.prototype.validateValue = function(value) {
		if(typeof this.validator == "function"){
			var msg = this.validator(value);
			if(msg !== true){
	            this.markInvalid(msg);
	            return false;
	        }
	    }
	    return true;
	};
	
	Ext.override(Ext.form.Checkbox, {
		onChange : function() {}
	});
}

if(Ext && Ext.form && Ext.form.ComboBox){ 
	Ext.override(Ext.form.ComboBox, {
		initEvents : function() {
			Ext.form.ComboBox.superclass.initEvents.call(this);
	
			this.keyNav = new Ext.KeyNav(this.el, {
				"up" : function(e) {
					this.inKeyMode = true;
					this.selectPrev();
				},
	
				"down" : function(e) {
					if (!this.isExpanded()) {
						this.onTriggerClick();
					} else {
						this.inKeyMode = true;
						this.selectNext();
					}
				},
	
				"enter" : function(e) {
					this.onViewClick();
					// return true;
				},
	
				"esc" : function(e) {
					this.collapse();
				},
	
				"tab" : function(e) {
					this.onViewClick(false);
					return true;
				},
	
				scope : this,
	
				doRelay : function(foo, bar, hname) {
					if (hname == 'down' || this.scope.isExpanded()) {
						return Ext.KeyNav.prototype.doRelay.apply(
								this, arguments);
					}
					return true;
				},
	
				forceKeyDown : true
			});
			this.queryDelay = Math.max(this.queryDelay || 10,
					this.mode == 'local' ? 10 : 250);
			this.dqTask = new Ext.util.DelayedTask(this.initQuery, this);
			if (this.typeAhead) {
				this.taTask = new Ext.util.DelayedTask(this.onTypeAhead,
						this);
			}
			if (this.editable !== false) {
				this.el.on("keyup", this.onKeyUp, this);
			}
			if (this.forceSelection) {
				this.on('blur', this.doForce, this);
			}
			if (!this.forceSelection && this.editable) {
				this.el.on("change", this.onChange, this);
			}
		},
	
		onChange : function() {
			var r = this.findRecord(this.displayField, this.el.getValue());
			var v;
			if (r) {
				v = r.data[this.valueField];
			} else {
				v = this.el.getValue();
			}
			this.setValue(v);
			this.fireEvent('change', this, v, this.startValue);
		}
	});
}