//计算tree所有隐藏域的值
//event:事件名
//node:触发事件的节点
//treeClientId:树的客户端ID
//tree:树的客户端变量名
window.buildEventParams = function(event, node, treeClientId, tree){
	if(node == null){
		return;
	}
	
	var seperator = ",";
	var rootNode = tree.getRootNode();
	OM.ajax.removeRequestParameter(treeClientId + "_eventName");
	OM.ajax.removeRequestParameter(treeClientId + "_eventNode");
	OM.ajax.addRequestParameter(treeClientId + "_eventName", event);
	OM.ajax.addRequestParameter(treeClientId + "_eventNode", node.id);
	if (node.attributes.userdata) {
		OM.ajax.removeRequestParameter(treeClientId + "_" + node.id + "_node_userData");
		OM.ajax.addRequestParameter(treeClientId + "_" + node.id + "_node_userData", node.attributes.userdata);
	}
	var source = "";
	if(rootNode.getUI().checked && rootNode.getUI().checked() == "checked"){
		source += rootNode.id + seperator;
	}
	source += getCheckNodes(tree.getRootNode(), seperator);
	OM.ajax.removeRequestParameter(treeClientId + "_checkedNodes");
	OM.ajax.addRequestParameter(treeClientId + "_checkedNodes", source);
	
	if(event == "select"){
		OM.ajax.removeRequestParameter(treeClientId + "_selectedNode");
		OM.ajax.addRequestParameter(treeClientId + "_selectedNode", node.id);
	}
	if(event == "collapsenode" || event == "expandnode"){
		var source = "";
		if(rootNode.isExpanded()){
			source += rootNode.id + seperator;
		}
		source += getExpandNodes(tree.getRootNode(), seperator);
		OM.ajax.removeRequestParameter(treeClientId + "_expandedNodes");
		OM.ajax.addRequestParameter(treeClientId + "_expandedNodes", source);
	}
}

//得到某个节点下的所有勾中节点的id，用seperator指定分隔符
window.getCheckNodes = function(node, seperator){
	var source = "";
	node.eachChild(function(child){
		if(child.getUI().checked && child.getUI().checked() == "checked"){
			source += child.id + seperator;
		}
		source += getCheckNodes(child, seperator);
	});
	return source;
}

//得到某个节点下的所有展开节点
window.getExpandNodes = function(node, seperator){
	var source = "";
	node.eachChild(function(child){
		if(child.isExpanded()){
			source += child.id + seperator;
		}
		source += getExpandNodes(child, seperator);
	});
	return source;
}

//更新某个节点下的所有节点
window.updateTreeNode = function(tree, loader, nodeId){
	var root = tree.getRootNode();
	var nodeToUpdate = null;
	if(nodeId == '' || nodeId == root.id){
		nodeToUpdate = root;
	}else{
		nodeToUpdate = findNodeById(root, nodeId);
	}
	if(nodeToUpdate != null){
		if(nodeToUpdate.isExpanded() || !hasChild(nodeToUpdate)){
			loader.load(nodeToUpdate,function(){
				nodeToUpdate.expand();
			});
		}else{
			nodeToUpdate.expand();
		}
	}
}

window.replaceRootNode = function(node, obj) {
	while (node.firstChild) {
		var c = node.firstChild;
		node.removeChild(c);
		c.destroy();
	}
	node.setText(obj.text);
} 

window.hasChild = function(node){
	var has = false;
	node.eachChild(function(child){
		has = true;
	});
	return has;
}

//查找指定节点下的某个节点
window.findNodeById = function(node,nodeId){
	if(node.id == nodeId){
		return node;
	}
	var n = null;
	node.eachChild(function(child){
		if(child.id == nodeId){
			n = child;
		}
		if(n == null){
			n = findNodeById(child, nodeId);
		}
	}); 
	return n;
}
