/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.transaction.UserTransaction;
import org.operamasks.faces.application.ApplicationListener;
import org.operamasks.faces.application.InjectionManager;
import org.operamasks.faces.application.InjectionManagerFactory;
import org.operamasks.faces.lifecycle.requestlistener.FacesRequestEventBroadcaster;
import org.operamasks.faces.lifecycle.requestlistener.FacesRequestListener;
import org.operamasks.faces.util.LoggerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationAssociate {
    public static final String ASSOCIATE_KEY = ApplicationAssociate.class.getName();
    private static final String APPLICATION_LISTENER_KEY = ApplicationListener.class.getName();
    private static final String APPLICATION_LISTENER_FILE_NAME = "META-INF/services/" + APPLICATION_LISTENER_KEY;
    private static final String FACES_REQUEST_LISTENER_KEY = FacesRequestListener.class.getName();
    private static final String FACES_REQUEST_LISTENER_FILE_NAME = "META-INF/services/" + FACES_REQUEST_LISTENER_KEY;
    private ConcurrentMap<String, Object> attributes;
    private ApplicationListener[] applicationListeners;
    private InjectionManager injectionManager;
    private FacesRequestEventBroadcaster facesReqEventBroadcaster;
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");
    private boolean requestMade;
    private boolean responseRendered;
    private String[] facesMappings = new String[0];
    private String resourceMapping;
    private UserTransaction userTransaction;
    private boolean transactionInited = false;
    private Map<String, String[]> resourceBundles = new HashMap<String, String[]>();

    public static ApplicationAssociate getInstance(ServletContext context) {
        return (ApplicationAssociate)context.getAttribute(ASSOCIATE_KEY);
    }

    public static ApplicationAssociate getInstance(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        return (ApplicationAssociate)applicationMap.get(ASSOCIATE_KEY);
    }

    public static ApplicationAssociate getInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context == null ? null : ApplicationAssociate.getInstance(context);
    }

    public ApplicationAssociate() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            throw new IllegalStateException("Cannot get Web application context during JSF Engine initialized.");
        }
        Map appMap = context.getExternalContext().getApplicationMap();
        if (appMap.containsKey(ASSOCIATE_KEY)) {
            throw new IllegalStateException("JSF Application associate already initialized.");
        }
        appMap.put(ASSOCIATE_KEY, this);
        this.attributes = new ConcurrentHashMap<String, Object>();
        this.injectionManager = InjectionManagerFactory.createInstance(context);
    }

    public ConcurrentMap<String, Object> getAttributes() {
        return this.attributes;
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public <T> T getSingleton(String key, Class<T> c) {
        Object singleton = this.attributes.get(key);
        if (singleton == null) {
            try {
                Constructor<T> cons = c.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                singleton = cons.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new AssertionError((Object)("The class " + c.getName() + " must have a no-args constructor."));
            }
            catch (InvocationTargetException ex) {
                throw new FacesException(ex.getTargetException());
            }
            catch (Exception ex) {
                throw new FacesException((Throwable)ex);
            }
            Object oldValue = this.attributes.putIfAbsent(key, singleton);
            if (oldValue != null) {
                singleton = oldValue;
            }
        }
        return (T)singleton;
    }

    public <T> T getSingleton(Class<T> c) {
        return this.getSingleton(c.getName(), c);
    }

    public InjectionManager getInjectionManager() {
        return this.injectionManager;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public synchronized ApplicationListener[] getApplicationListeners() {
        if (this.applicationListeners == null) {
            this.applicationListeners = this.loadApplicationListeners();
        }
        return this.applicationListeners;
    }

    public synchronized FacesRequestEventBroadcaster getFacesRequestEventBroadcaster() {
        if (this.facesReqEventBroadcaster == null) {
            this.facesReqEventBroadcaster = this.loadFacesReqEventBroadcaster();
        }
        return this.facesReqEventBroadcaster;
    }

    private FacesRequestEventBroadcaster loadFacesReqEventBroadcaster() {
        List<FacesRequestListener> listeners = this.loadListeners(FACES_REQUEST_LISTENER_FILE_NAME, "faces request listener");
        FacesRequestEventBroadcaster broadcaster = new FacesRequestEventBroadcaster();
        broadcaster.addFacesRequestListeners(listeners.toArray(new FacesRequestListener[listeners.size()]));
        return broadcaster;
    }

    private ApplicationListener[] loadApplicationListeners() {
        List<ApplicationListener> listeners = this.loadListeners(APPLICATION_LISTENER_FILE_NAME, "application listener");
        return listeners.toArray(new ApplicationListener[listeners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<T> loadListeners(String filename, String listenerTypeName) {
        ClassLoader cl = this.getClassLoader();
        ArrayList listeners = new ArrayList();
        BufferedReader reader = null;
        InputStream stream = null;
        try {
            Enumeration<URL> urls;
            Enumeration<URL> enumeration = urls = cl == null ? ClassLoader.getSystemResources(filename) : cl.getResources(filename);
            while (urls.hasMoreElements()) {
                String name;
                URL url = urls.nextElement();
                stream = url.openStream();
                reader = new BufferedReader(new InputStreamReader(stream));
                while ((name = reader.readLine()) != null) {
                    if ((name = name.trim()).length() == 0) continue;
                    try {
                        Class<?> clazz = cl == null ? Class.forName(name) : cl.loadClass(name);
                        Object listener = clazz.newInstance();
                        listeners.add(listener);
                    }
                    catch (Throwable ex) {
                        this.logger.log(Level.FINEST, "Could not load " + listenerTypeName + ": " + name, ex);
                    }
                }
                stream.close();
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Load " + listenerTypeName + "s failed.", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "close stream failed.", e);
                }
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "close stream failed.", e);
                }
            }
        }
        return listeners;
    }

    public void requestMade() {
        this.requestMade = true;
    }

    public boolean isRequestMade() {
        return this.requestMade;
    }

    public void responseRendered() {
        this.responseRendered = true;
    }

    public boolean isResponseRendered() {
        return this.responseRendered;
    }

    public String[] getFacesMappings() {
        return (String[])this.facesMappings.clone();
    }

    public void setFacesMappings(String[] facesMappings) {
        assert (facesMappings != null);
        this.facesMappings = facesMappings;
    }

    public String getResourceMapping() {
        return this.resourceMapping;
    }

    public void setResourceMapping(String mapping) {
        if (mapping != null) {
            if (mapping.startsWith("/") && mapping.endsWith("/*")) {
                mapping = mapping.substring(0, mapping.length() - 2);
            } else {
                return;
            }
        }
        this.resourceMapping = mapping;
    }

    public String getViewId(FacesContext context) {
        String pathInfo;
        ExternalContext ectx = context.getExternalContext();
        Map requestMap = ectx.getRequestMap();
        String path = (String)requestMap.get("javax.servlet.include.servlet_path");
        if (path != null) {
            pathInfo = (String)requestMap.get("javax.servlet.include.path_info");
        } else {
            path = ectx.getRequestServletPath();
            pathInfo = ectx.getRequestPathInfo();
        }
        if (path == null || path.length() == 0) {
            return null;
        }
        for (String mapping : this.facesMappings) {
            char c = mapping.charAt(0);
            if (c == '/') {
                if (!mapping.equals(path)) continue;
                if (pathInfo == null) {
                    return path;
                }
                int length = mapping.length();
                String prefix = mapping.concat("/");
                while (pathInfo.startsWith(prefix)) {
                    pathInfo = pathInfo.substring(length);
                }
                return pathInfo;
            }
            if (c != '.' || !path.endsWith(mapping)) continue;
            return path;
        }
        return pathInfo != null ? pathInfo : path;
    }

    public String getFacesMapping(FacesContext context) {
        ExternalContext ectx = context.getExternalContext();
        Map requestMap = ectx.getRequestMap();
        String path = (String)requestMap.get("javax.servlet.include.servlet_path");
        if (path == null) {
            path = ectx.getRequestServletPath();
        }
        if (path == null || path.length() == 0) {
            return null;
        }
        for (String mapping : this.facesMappings) {
            char c = mapping.charAt(0);
            if (!(c == '/' ? mapping.equals(path) : c == '.' && path.endsWith(mapping))) continue;
            return mapping;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTransaction getUserTransaction() {
        if (!this.transactionInited) {
            try {
                InitialContext initctx = new InitialContext();
                this.userTransaction = (UserTransaction)initctx.lookup("java:comp/UserTransaction");
            }
            catch (Exception ex) {
                this.userTransaction = null;
            }
            finally {
                this.transactionInited = true;
            }
        }
        return this.userTransaction;
    }

    public void addResourceBundle(String var, String baseName, String displayName) {
        String[] rb = new String[]{baseName, displayName};
        this.resourceBundles.put(var, rb);
    }

    public String getResourceBundleBaseName(String var) {
        String[] rb = this.resourceBundles.get(var);
        return rb != null ? rb[0] : null;
    }

    public String getResourceBundleDisplayName(String var) {
        String[] rb = this.resourceBundles.get(var);
        return rb != null ? rb[1] : null;
    }

    public Collection<String> getResourceBundles() {
        return this.resourceBundles.keySet();
    }
}

