/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.operamasks.faces.application.InjectionManager;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.util.Utils;

public abstract class InjectionManagerFactory {
    private static final String FACTORY_KEY = InjectionManagerFactory.class.getName();
    private static final String FACTORY_SERVICE = "META-INF/services/" + FACTORY_KEY;
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");

    protected abstract InjectionManager newInjectionManager(FacesContext var1);

    public static InjectionManager createInstance(FacesContext context) {
        for (String classname : InjectionManagerFactory.getFactoryClasses(context)) {
            try {
                Class clazz = Utils.findClass((String)classname);
                InjectionManagerFactory factory = (InjectionManagerFactory)clazz.newInstance();
                InjectionManager manager = factory.newInjectionManager(context);
                if (manager == null) continue;
                return manager;
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return new NoopInjectionManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getFactoryClasses(FacesContext context) {
        String provider = context.getExternalContext().getInitParameter(FACTORY_KEY);
        if (provider != null) {
            return new String[]{provider};
        }
        provider = System.getProperty(FACTORY_KEY);
        if (provider != null) {
            return new String[]{provider};
        }
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        InputStream input = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources(FACTORY_SERVICE);
            while (resources.hasMoreElements()) {
                input = resources.nextElement().openStream();
                try {
                    reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                    String line = reader.readLine();
                    while (line != null) {
                        list.add(line.trim());
                        line = reader.readLine();
                    }
                }
                finally {
                    input.close();
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "read factory service file fails: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static class NoopInjectionManager
    implements InjectionManager {
        private NoopInjectionManager() {
        }

        public void inject(Object bean) {
        }

        public void invokePostConstruct(Object bean) {
        }

        public void invokePreDestroy(Object bean) {
        }
    }
}

