/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application;

import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ManagedBeanFactory;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.conversation.ConversationContextManager;
import org.operamasks.faces.util.LoggerUtil;

public class ManagedBeanLifecycleListener
implements ServletContextListener,
HttpSessionListener,
ServletRequestListener {
    private ServletContext context;
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");

    public void contextInitialized(ServletContextEvent event) {
        this.context = event.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        Enumeration en = context.getAttributeNames();
        while (en.hasMoreElements()) {
            String beanName = (String)en.nextElement();
            this.destroyBean(beanName, context.getAttribute(beanName), ManagedBeanScope.APPLICATION);
        }
    }

    public void sessionCreated(HttpSessionEvent evnet) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        Enumeration en = session.getAttributeNames();
        while (en.hasMoreElements()) {
            String beanName = (String)en.nextElement();
            this.destroyBean(beanName, session.getAttribute(beanName), ManagedBeanScope.SESSION);
        }
        this.destroyConversationBeans(session);
    }

    private void destroyConversationBeans(HttpSession session) {
        ConversationContextManager manager = (ConversationContextManager)session.getAttribute("_ConersationContextManager_");
        if (manager != null) {
            Map<String, ConversationContext> cctxMap = manager.getCctxMap();
            for (ConversationContext cctxt : cctxMap.values()) {
                Map<String, Object> map = cctxt.getConversationMap();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    String beanName = entry.getKey();
                    this.destroyBean(beanName, entry.getValue(), ManagedBeanScope.CONVERSATION);
                }
            }
        }
    }

    public void requestInitialized(ServletRequestEvent event) {
    }

    public void requestDestroyed(ServletRequestEvent event) {
        ServletRequest request = event.getServletRequest();
        Enumeration en = request.getAttributeNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            this.destroyBean(name, request.getAttribute(name), ManagedBeanScope.REQUEST);
        }
    }

    private void destroyBean(String beanName, Object bean, ManagedBeanScope scope) {
        try {
            ManagedBeanFactory factory;
            ManagedBeanContainer container = ManagedBeanContainer.getInstance(this.context);
            if (container != null && (factory = container.getBeanFactory(beanName)) != null && scope == factory.getScope() && factory.isInstance(bean)) {
                factory.destroyBean(bean);
            }
        }
        catch (Throwable ex) {
            this.logger.log(Level.FINE, ex.getMessage(), ex);
        }
    }
}

