/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.groovy;

import groovy.lang.GroovyClassLoader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELResolver;
import javax.servlet.ServletContext;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.ApplicationEvent;
import org.operamasks.faces.application.ApplicationListener;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ConverterRegistry;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.application.ValidatorRegistry;
import org.operamasks.faces.application.groovy.GroovyBeanCreator;
import org.operamasks.faces.application.groovy.GroovyELResolver;
import org.operamasks.faces.application.groovy.GroovyManagedBeanFactory;
import org.operamasks.faces.application.groovy.GroovyScript;
import org.operamasks.faces.application.groovy.GroovyTargetCreator;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.config.AnnotationProcessor;
import org.operamasks.faces.config.ConverterConfig;
import org.operamasks.faces.config.ManagedBeanConfig;
import org.operamasks.faces.config.ValidatorConfig;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

public class GroovyApplicationListener
implements ApplicationListener {
    private static final String BASE_PATH = "/WEB-INF/groovy/";
    private static final String SUFFIX = ".groovy";
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");
    private GroovyClassLoader groovyClassLoader;
    private AnnotationProcessor annotationProcessor;

    public void applicationCreated(ApplicationEvent event) {
    }

    public void applicationDestroyed(ApplicationEvent event) {
    }

    public void applicationInitialized(ApplicationEvent event) {
        ServletContext context = event.getServletContext();
        ApplicationAssociate assoc = ApplicationAssociate.getInstance(context);
        final ClassLoader loader = assoc.getClassLoader();
        try {
            this.groovyClassLoader = (GroovyClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new GroovyClassLoader(loader);
                }
            });
        }
        catch (NoClassDefFoundError ex) {
            return;
        }
        try {
            URL url = context.getResource(BASE_PATH);
            if (url != null) {
                this.groovyClassLoader.addURL(url);
                this.annotationProcessor = new AnnotationProcessor(context, loader);
                this.scan(context, BASE_PATH);
            }
        }
        catch (MalformedURLException ex) {
            throw new InternalError();
        }
        event.getApplication().addELResolver((ELResolver)new GroovyELResolver());
        ModelBindingFactory mbf = ModelBindingFactory.instance();
        mbf.setModelBeanCreator(new GroovyBeanCreator(mbf.getModelBeanCreator()));
    }

    private void scan(ServletContext context, String path) {
        Set paths = context.getResourcePaths(path);
        if (paths != null) {
            for (String file : paths) {
                if (file.endsWith("/")) {
                    this.scan(context, file);
                    continue;
                }
                if (!file.endsWith(SUFFIX)) continue;
                this.parseGroovyScript(context, file);
            }
        }
    }

    private void parseGroovyScript(ServletContext context, String filename) {
        URL resource;
        try {
            resource = context.getResource(filename);
            if (resource == null) {
                return;
            }
        }
        catch (MalformedURLException ex) {
            throw new InternalError();
        }
        try {
            ValidatorConfig validator;
            ConverterConfig converter;
            GroovyScript script = new GroovyScript(this.groovyClassLoader, resource, filename);
            Class<?> scriptClass = script.getScriptClass();
            ManagedBeanConfig mbean = this.annotationProcessor.scanManagedBeanClass(scriptClass);
            if (mbean != null) {
                GroovyManagedBeanFactory factory = new GroovyManagedBeanFactory(mbean, script);
                ManagedBeanContainer.getInstance().addBeanFactory(factory);
            }
            if ((converter = this.annotationProcessor.scanConverterClass(scriptClass)) != null) {
                String converterType;
                ConverterRegistry registry = ConverterRegistry.getInstance();
                ConverterFactory factory = registry.createConverterFactory(new GroovyTargetCreator(script));
                String converterId = converter.getConverterId();
                if (converterId != null) {
                    registry.addConverterFactory(converterId, factory);
                }
                if ((converterType = converter.getConverterForClass()) != null) {
                    try {
                        Class c = this.groovyClassLoader.loadClass(converterType);
                        registry.addConverterFactory(c, factory);
                    }
                    catch (ClassNotFoundException ex) {
                        this.logger.severe(Resources._T("JSF_CLASS_NOT_FOUND", converterType));
                    }
                }
            }
            if ((validator = this.annotationProcessor.scanValidatorClass(scriptClass)) != null) {
                ValidatorRegistry registry = ValidatorRegistry.getInstance();
                ValidatorFactory factory = registry.createValidatorFactory(new GroovyTargetCreator(script));
                registry.addValidatorFactory(validator.getValidatorId(), factory);
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error occurred while parsing groovy script '" + filename + "'.", ex);
        }
    }
}

