/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.Serializable;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.operamasks.faces.component.ComponentContainer;
import org.operamasks.faces.component.ComponentFactory;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

public class ChildComponentStructure
implements Serializable {
    private static final long serialVersionUID = -8824748622909968116L;
    private String id;
    private String className;

    public ChildComponentStructure() {
    }

    public ChildComponentStructure(UIComponent component) {
        this.id = component.getId();
        this.className = component.getClass().getName();
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public UIComponent createComponent() {
        try {
            Class c = Utils.findClass((String)this.className);
            ComponentContainer container = ComponentContainer.getInstance();
            ComponentFactory fac = container.getComponentFactoryByName(c.getName());
            if (fac == null) {
                throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", c.getName()));
            }
            UIComponent newComponent = fac.createComponent();
            if (this.id != null) {
                newComponent.setId(this.id);
            }
            return newComponent;
        }
        catch (Throwable ex) {
            throw new FacesException(ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChildComponentStructure other = (ChildComponentStructure)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

