/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.convert.Converter;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ConverterRegistry;
import org.operamasks.faces.application.TargetCreator;
import org.operamasks.faces.binding.factories.AdaptingConverterFactory;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverterRegistry
extends ConverterRegistry {
    private Map<String, ConverterFactory> registryById = new ConcurrentHashMap<String, ConverterFactory>();
    private Map<Class, ConverterFactory> registryByType = new ConcurrentHashMap<Class, ConverterFactory>();
    private Set<Class> converterTypes = Collections.synchronizedSet(new HashSet());

    protected DefaultConverterRegistry() {
    }

    @Override
    public ConverterFactory createConverterFactory(TargetCreator creator) {
        return new AdaptingConverterFactory(creator);
    }

    @Override
    public ConverterFactory createConverterFactory(Class<?> converterClass) {
        return new AdaptingConverterFactory(converterClass);
    }

    @Override
    public void addConverterFactory(String converterId, ConverterFactory converterFactory) {
        this.registryById.put(converterId, converterFactory);
    }

    @Override
    public void addConverterFactory(Class targetClass, ConverterFactory converterFactory) {
        this.registryByType.put(targetClass, converterFactory);
        this.converterTypes.add(targetClass);
    }

    @Override
    public ConverterFactory getConverterFactory(String converterId) {
        return this.registryById.get(converterId);
    }

    @Override
    public ConverterFactory getConverterFactory(Class targetClass) {
        return this.registryByType.get(targetClass);
    }

    @Override
    public Converter createConverter(String converterId) {
        ConverterFactory converterFactory = this.registryById.get(converterId);
        if (converterFactory == null) {
            throw new FacesException(Resources._T("JSF_NO_SUCH_CONVERTER_ID", converterId));
        }
        return converterFactory.createConverter(null);
    }

    @Override
    public Converter createConverter(Class targetClass) {
        if (targetClass.isPrimitive()) {
            targetClass = Utils.getWrapperClass((Class)targetClass);
        }
        return this.createConverterForType(targetClass, targetClass);
    }

    private Converter createConverterForType(Class targetClass, Class baseClass) {
        Converter result = this.newConverter(targetClass, baseClass);
        if (result != null) {
            return result;
        }
        for (Class<?> c : targetClass.getInterfaces()) {
            result = this.createConverterForType(c, baseClass);
            if (result == null) continue;
            return result;
        }
        Class superclass = targetClass.getSuperclass();
        if (superclass != null && (result = this.createConverterForType(superclass, baseClass)) != null) {
            return result;
        }
        return null;
    }

    private Converter newConverter(Class targetClass, Class baseClass) {
        ConverterFactory factory = this.registryByType.get(targetClass);
        if (factory == null) {
            return null;
        }
        if (baseClass != targetClass) {
            this.registryByType.put(baseClass, factory);
        }
        return factory.createConverter(baseClass);
    }

    @Override
    public Iterator<String> getConverterIds() {
        return this.registryById.keySet().iterator();
    }

    @Override
    public Iterator<Class> getConverterTypes() {
        return this.converterTypes.iterator();
    }
}

