/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.ViewMapper;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultViewMapper
implements ViewMapper {
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");
    private ViewMapping viewMapping = new ViewMapping();
    private SimpleCache<String, List<String>> cache = SimpleCache.make((int)20);
    private static final String FULL_VIEW_ID = "#{~view}";
    private static final String FULL_VIEW_ID_CAPITALIZE = "#{~View}";
    private static final String WILDCARD_VIEW_ID = "#{@view}";
    private static final String WILDCARD_VIEW_ID_CAPITALIZE = "#{@View}";
    private static final String VIEW_NAME_ONLY = "#{view}";
    private static final String VIEW_NAME_ONLY_CAPITALIZE = "#{View}";

    public static DefaultViewMapper getInstance() {
        return ApplicationAssociate.getInstance().getSingleton(DefaultViewMapper.class);
    }

    protected DefaultViewMapper() {
    }

    public void addViewMapping(String viewId, String beanName) {
        this.viewMapping.addMapping(viewId, beanName);
    }

    @Override
    public List<String> mapViewId(String viewId) {
        List<String> resultList = (List<String>)this.cache.get((Object)viewId);
        if (resultList != null) {
            return resultList;
        }
        resultList = this.viewMapping.findMapping(viewId);
        for (int i = 0; i < resultList.size(); ++i) {
            String beanName = resultList.get(i);
            if (beanName.indexOf("#{") == -1) continue;
            beanName = this.mapViewId(beanName, viewId);
            resultList.set(i, beanName);
        }
        if (logger.isLoggable(Level.FINER)) {
            boolean first = true;
            StringBuffer beansBuf = new StringBuffer();
            for (String b : resultList) {
                if (first) {
                    beansBuf.append(b);
                    first = false;
                    continue;
                }
                beansBuf.append(", ").append(b);
            }
            logger.finer("operamasks.xml ViewMapping [" + viewId + " -> {" + beansBuf.toString() + "}]");
        }
        this.cache.put((Object)viewId, resultList);
        return resultList;
    }

    private String mapViewId(String pattern, String viewId) {
        int dash;
        int dot;
        if (viewId.startsWith("/")) {
            viewId = viewId.substring(1);
        }
        if ((dot = viewId.lastIndexOf(46)) > viewId.lastIndexOf(47)) {
            viewId = viewId.substring(0, dot);
        }
        if (pattern.startsWith("/")) {
            return pattern.replace(FULL_VIEW_ID, viewId).replace(VIEW_NAME_ONLY, viewId);
        }
        viewId = viewId.replace('/', '.');
        while ((dash = viewId.indexOf(45)) != -1) {
            viewId = viewId.substring(0, dash) + DefaultViewMapper.capitalize(viewId.substring(dash + 1));
        }
        int lastDot = viewId.lastIndexOf(46);
        if (pattern.indexOf(FULL_VIEW_ID) != -1) {
            return pattern.replace(FULL_VIEW_ID, viewId);
        }
        if (pattern.indexOf(FULL_VIEW_ID_CAPITALIZE) != -1) {
            viewId = DefaultViewMapper.capitalize(viewId, lastDot + 1);
            return pattern.replace(FULL_VIEW_ID_CAPITALIZE, viewId);
        }
        if (pattern.indexOf(WILDCARD_VIEW_ID) != -1) {
            viewId = this.getWildcardViewId(viewId);
            return pattern.replace(WILDCARD_VIEW_ID, viewId);
        }
        if (pattern.indexOf(WILDCARD_VIEW_ID_CAPITALIZE) != -1) {
            viewId = this.getWildcardViewId(viewId);
            lastDot = viewId.lastIndexOf(46);
            viewId = DefaultViewMapper.capitalize(viewId, lastDot + 1);
            return pattern.replace(WILDCARD_VIEW_ID_CAPITALIZE, viewId);
        }
        if (pattern.indexOf(VIEW_NAME_ONLY) != -1) {
            viewId = viewId.substring(lastDot + 1);
            return pattern.replace(VIEW_NAME_ONLY, viewId);
        }
        if (pattern.indexOf(VIEW_NAME_ONLY_CAPITALIZE) != -1) {
            viewId = DefaultViewMapper.capitalize(viewId.substring(lastDot + 1));
            return pattern.replace(VIEW_NAME_ONLY_CAPITALIZE, viewId);
        }
        return pattern;
    }

    private String getWildcardViewId(String viewId) {
        for (String wildward : this.viewMapping.wildcards) {
            if ((wildward = wildward.replace('/', '.')).startsWith(".")) {
                wildward = wildward.substring(1);
            }
            if (!viewId.startsWith(wildward)) continue;
            return wildward;
        }
        return viewId;
    }

    private static final String capitalize(String s) {
        if (s.length() > 0) {
            s = Character.toUpperCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    private static final String capitalize(String s, int i) {
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        if (i < s.length() - 1) {
            s = s.substring(0, i) + Character.toUpperCase(s.charAt(i)) + s.substring(i + 1);
        }
        return s;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ViewMapping {
        private Map<String, List<String>> viewMap = new HashMap<String, List<String>>();
        private TreeSet<String> wildcards = new TreeSet<String>(new DescOrder());

        private ViewMapping() {
        }

        public void addMapping(String viewId, String beanName) {
            List<String> beanList = this.viewMap.get(viewId);
            if (beanList == null) {
                beanList = new ArrayList<String>();
                this.viewMap.put(viewId, beanList);
            }
            if (!beanList.contains(beanName)) {
                beanList.add(beanName);
            }
            if (viewId.endsWith("*") && !viewId.equals("*")) {
                viewId = viewId.substring(0, viewId.length() - 1);
                this.wildcards.add(viewId);
            }
        }

        public List<String> findMapping(String viewId) {
            ArrayList<String> resultList = new ArrayList<String>();
            List<String> beanList = this.viewMap.get(viewId);
            if (beanList != null) {
                resultList.addAll(beanList);
            }
            if (resultList.size() > 0) {
                return resultList;
            }
            beanList = this.viewMap.get(viewId.substring(1));
            if (beanList != null) {
                resultList.addAll(beanList);
            }
            if (resultList.size() > 0) {
                return resultList;
            }
            beanList = this.viewMap.get(viewId.substring(viewId.lastIndexOf("/") + 1));
            if (beanList != null) {
                resultList.addAll(beanList);
            }
            if (resultList.size() > 0) {
                return resultList;
            }
            for (String wildcard : this.wildcards) {
                if (!viewId.startsWith(wildcard) || (beanList = this.viewMap.get(wildcard.concat("*"))) == null) continue;
                resultList.addAll(beanList);
            }
            beanList = this.viewMap.get("*");
            if (beanList != null) {
                resultList.addAll(beanList);
            }
            return resultList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DescOrder
    implements Comparator<String>,
    Serializable {
        private DescOrder() {
        }

        @Override
        public int compare(String a, String b) {
            return b.compareTo(a);
        }
    }
}

