/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.vendor.apusic;

import com.apusic.deploy.runtime.EJBModel;
import com.apusic.deploy.runtime.EJBModule;
import com.apusic.deploy.runtime.J2EEApplication;
import com.apusic.deploy.runtime.J2EEModule;
import com.apusic.deploy.runtime.SessionBeanModel;
import com.apusic.deploy.runtime.WebModule;
import com.apusic.ejb.container.MethodDesc;
import com.apusic.web.container.WebContainer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.SessionBean;
import javax.servlet.ServletContext;
import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ApplicationEvent;
import org.operamasks.faces.application.ApplicationListener;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ManagedBeanFactory;
import org.operamasks.faces.application.vendor.apusic.EJBManagedBeanFactory;
import org.operamasks.faces.application.vendor.apusic.EJBMethodMap;
import org.operamasks.faces.application.vendor.apusic.EJBModelBeanCreator;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.config.AnnotationProcessor;
import org.operamasks.faces.config.ManagedBeanConfig;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

public class ApusicApplicationListener
implements ApplicationListener {
    private WebContainer container;
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");

    public ApusicApplicationListener() throws Exception {
        Class.forName("com.apusic.web.container.WebContainer");
    }

    public void applicationCreated(ApplicationEvent event) {
    }

    public void applicationDestroyed(ApplicationEvent event) {
    }

    public void applicationInitialized(ApplicationEvent event) {
        ServletContext context = event.getServletContext();
        if (context instanceof WebContainer) {
            this.container = (WebContainer)context;
            this.logger.finest("Initializing Apusic JSF application.");
            this.initializeDependencyInjections();
            this.initializeEJBManagedBeans();
        }
    }

    private void initializeDependencyInjections() {
        WebModule webapp = this.container.getWebModule();
        ClassLoader loader = this.container.getClassLoader();
        for (ManagedBeanFactory mbf : ManagedBeanContainer.getInstance().getBeanFactories()) {
            String className = mbf.getBeanClassName();
            try {
                Class mbeanClass = Utils.findClass((String)className, (ClassLoader)mbf.getClassLoader());
                webapp.discoverClass(mbeanClass);
            }
            catch (ClassNotFoundException ex) {
                this.logger.log(Level.SEVERE, Resources._T("JSF_CLASS_NOT_FOUND", className));
            }
        }
        try {
            webapp.getEnvContext().initializeInjections((J2EEModule)webapp, loader);
            webapp.resolveExternalReferences();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "Error to initialize dependency injections.", ex);
        }
    }

    private void initializeEJBManagedBeans() {
        J2EEApplication app = this.container.getWebModule().getApplication();
        for (J2EEModule module : app.getModuleList()) {
            if (!(module instanceof EJBModule)) continue;
            for (EJBModel ejb : ((EJBModule)module).getEjbList()) {
                if (!ejb.isSession() || ejb.getBusinessLocal() == null) continue;
                this.initializeEJBManagedBean((SessionBeanModel)ejb);
            }
        }
        ModelBindingFactory bf = ModelBindingFactory.instance();
        bf.setModelBeanCreator(new EJBModelBeanCreator(bf.getModelBeanCreator()));
    }

    private void initializeEJBManagedBean(SessionBeanModel model) {
        MethodDesc[] table = this.getMethodTable(model);
        this.registerEJBMethodMapping(table);
        Class ejbClass = model.getEjbClass();
        ManagedBean meta = ejbClass.getAnnotation(ManagedBean.class);
        if (meta != null) {
            this.registerEJBManagedBean(model, meta, table);
        }
    }

    private void registerEJBManagedBean(SessionBeanModel model, ManagedBean meta, MethodDesc[] table) {
        ManagedBeanScope scope;
        Class ejbClass = model.getEjbClass();
        String beanName = meta.name();
        if (beanName == null || beanName.length() == 0) {
            String classname = ejbClass.getName();
            beanName = classname.substring(classname.lastIndexOf(46) + 1);
        }
        if ((scope = meta.scope()) == ManagedBeanScope.NONE) {
            scope = model.isStateless() ? ManagedBeanScope.REQUEST : ManagedBeanScope.SESSION;
        }
        ManagedBeanConfig config = null;
        try {
            AnnotationProcessor processor = new AnnotationProcessor((ServletContext)this.container, this.container.getClassLoader());
            config = processor.scanManagedBeanClass(ejbClass);
        }
        catch (Exception ex) {
            // empty catch block
        }
        MethodDesc remove = null;
        if (!model.isStateless()) {
            remove = this.findRemoveMethod(model, table);
        }
        EJBManagedBeanFactory factory = new EJBManagedBeanFactory(beanName, scope, config, model, remove);
        ManagedBeanContainer.getInstance().addBeanFactory(factory);
    }

    private MethodDesc[] getMethodTable(SessionBeanModel model) {
        try {
            String businessObjectClassName = model.getBusinessLocalObjectImpl();
            Class businessObjectClass = Utils.findClass((String)businessObjectClassName, (ClassLoader)this.container.getClassLoader());
            Field methodTableField = businessObjectClass.getField("__method_table");
            return (MethodDesc[])methodTableField.get(null);
        }
        catch (SecurityException e) {
            return new MethodDesc[0];
        }
        catch (IllegalArgumentException e) {
            return new MethodDesc[0];
        }
        catch (ClassNotFoundException e) {
            return new MethodDesc[0];
        }
        catch (NoSuchFieldException e) {
            return new MethodDesc[0];
        }
        catch (IllegalAccessException e) {
            return new MethodDesc[0];
        }
    }

    private void registerEJBMethodMapping(MethodDesc[] table) {
        EJBMethodMap ejbMethodMap = EJBMethodMap.getInstance();
        for (MethodDesc md : table) {
            if (md.getMethod() != null) {
                ejbMethodMap.put(md.getMethod(), md);
            }
            if (md.getEjbMethod() == null) continue;
            ejbMethodMap.put(md.getEjbMethod(), md);
        }
    }

    private MethodDesc findRemoveMethod(SessionBeanModel model, MethodDesc[] table) {
        for (MethodDesc md : table) {
            if (!md.isRemove()) continue;
            Method method = md.getEjbMethod();
            if (method == null) {
                return md;
            }
            if (method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 0) continue;
            return md;
        }
        Method method = this.findRemoveMethod(model);
        MethodDesc remove = new MethodDesc(null, method, 514);
        remove.setTxAttr(0);
        remove.setUnchecked();
        return remove;
    }

    private Method findRemoveMethod(SessionBeanModel model) {
        Class ejbClass = model.getEjbClass();
        if (SessionBean.class.isAssignableFrom(ejbClass)) {
            try {
                return ejbClass.getMethod("ejbRemove", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
        for (Method method : ejbClass.getDeclaredMethods()) {
            if (method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 0 || model.getRemoveMethod(method, 0) == null) continue;
            return method;
        }
        try {
            return ejbClass.getMethod("ejbRemove", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }
}

