/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.factories;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.validator.Validator;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.ValidatorAdapter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizingValidatorFactory
implements ValidatorFactory {
    private ValidatorFactory delegate;
    private Map<String, Object> properties;
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.binding");

    public CustomizingValidatorFactory(ValidatorFactory delegate) {
        this.delegate = delegate;
        this.properties = new HashMap<String, Object>();
    }

    public void setValidatorProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Validator createValidator() {
        return this.createValidator(null);
    }

    public Validator createValidator(ModelBean scope) {
        Validator validator = this.delegate.createValidator();
        if (validator != null && this.properties.size() > 0) {
            this.setValidatorProperties(scope, validator);
        }
        return validator;
    }

    protected void setValidatorProperties(ModelBean scope, Validator validator) {
        ModelBean bean = this.getValidatorBean(validator);
        Class<?> tclass = bean.getTargetClass();
        for (String name : this.properties.keySet()) {
            try {
                BeanProperty p = BeanUtils.getProperty(tclass, (String)name);
                if (p == null) {
                    logger.warning(Resources._T("MVB_VALIDATOR_PROPERTY_NOT_FOUND", name, tclass.getName()));
                    continue;
                }
                if (p.isReadOnly()) {
                    logger.warning(Resources._T("MVB_VALIDATOR_PROPERTY_READONLY", name, tclass.getName()));
                    continue;
                }
                Object value = this.properties.get(name);
                if (value instanceof String) {
                    value = this.convertStringValue(scope, (String)value, p.getType());
                } else if (!p.getType().isInstance(value)) {
                    value = TypeCoercion.coerce((Object)value, (Class)p.getType());
                }
                if (value == null) continue;
                bean.invoke(p.getWriteMethod(), value);
            }
            catch (Exception ex) {
                throw new FacesException(Resources._T("MVB_SET_VALIDATOR_PROPERTY_FAILED", name, tclass.getName()), (Throwable)ex);
            }
        }
    }

    private Object convertStringValue(ModelBean scope, String value, Class<?> type) {
        if (value.length() == 0) {
            return null;
        }
        if (scope != null) {
            return scope.evaluateExpression(value, type);
        }
        return FacesUtils.evaluateExpressionGet(value, type);
    }

    private ModelBean getValidatorBean(Object validator) {
        if (validator instanceof ValidatorAdapter) {
            return ((ValidatorAdapter)validator).getModelBean();
        }
        return ModelBean.wrap(validator);
    }
}

