/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.factories;

import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import org.operamasks.faces.internal.util.OMUtils;

public class DelegatingDateTimeConverter
implements Converter {
    private DateTimeConverter delegate = (DateTimeConverter)FacesContext.getCurrentInstance().getApplication().createConverter("javax.faces.DateTime");

    public void setDateStyle(String value) {
        if (value.length() != 0) {
            this.delegate.setDateStyle(value);
        }
    }

    public void setTimeStyle(String value) {
        if (value.length() != 0) {
            this.delegate.setTimeStyle(value);
        }
    }

    public void setPattern(String value) {
        if (value.length() != 0) {
            this.delegate.setPattern(value);
        }
    }

    public String getPattern() {
        return this.delegate.getPattern();
    }

    public void setType(String value) {
        if (value.length() != 0) {
            this.delegate.setType(value);
        }
    }

    public void setLocale(String value) {
        if (value.length() != 0) {
            this.delegate.setLocale(OMUtils.getLocaleFromString(value));
        }
    }

    public void setTimeZone(String value) {
        if (value.length() != 0) {
            this.delegate.setTimeZone(TimeZone.getTimeZone(value));
        }
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        this.checkType();
        return this.delegate.getAsObject(context, component, value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        this.checkType();
        return this.delegate.getAsString(context, component, value);
    }

    private void checkType() {
        if (this.delegate.getType() == null && this.delegate.getPattern() == null) {
            if (this.delegate.getDateStyle() != null && this.delegate.getTimeStyle() != null) {
                this.delegate.setType("both");
            } else if (this.delegate.getDateStyle() != null) {
                this.delegate.setType("date");
            } else if (this.delegate.getTimeStyle() != null) {
                this.delegate.setType("time");
            }
        }
    }
}

