/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import java.util.List;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.validator.EmptyValueValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.operamasks.faces.validator.ClientValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeValidator
implements Validator,
ClientValidator,
StateHolder {
    private List<Validator> validators = new ArrayList<Validator>();
    private PhaseId phaseId;
    private boolean isTransient;

    public static CompositeValidator getCompositeValidator(EditableValueHolder vh, PhaseId phaseId) {
        CompositeValidator composite = null;
        for (Validator v : vh.getValidators()) {
            if (!(v instanceof CompositeValidator) || v instanceof EmptyValueValidator) continue;
            if (phaseId != ((CompositeValidator)v).getPhaseId()) {
                vh.removeValidator(v);
                continue;
            }
            composite = (CompositeValidator)v;
            break;
        }
        if (composite == null) {
            composite = new CompositeValidator();
            composite.setPhaseId(phaseId);
            vh.addValidator((Validator)composite);
        }
        return composite;
    }

    public static CompositeValidator getCompositeValidator(EditableValueHolder vh, PhaseId phaseId, boolean ignoreEmpty) {
        CompositeValidator composite = null;
        for (Validator v : vh.getValidators()) {
            if (!(v instanceof CompositeValidator) || (!ignoreEmpty || v instanceof EmptyValueValidator) && (ignoreEmpty || !(v instanceof EmptyValueValidator))) continue;
            if (phaseId != ((CompositeValidator)v).getPhaseId()) {
                vh.removeValidator(v);
                continue;
            }
            composite = (CompositeValidator)v;
            break;
        }
        if (composite == null) {
            composite = ignoreEmpty ? new CompositeValidator() : new EmptyValueCompositeValidator();
            composite.setPhaseId(phaseId);
            vh.addValidator((Validator)composite);
        }
        return composite;
    }

    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(PhaseId phaseId) {
        this.phaseId = phaseId;
    }

    public void addValidator(Validator validator) {
        this.validators.add(validator);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        for (Validator v : this.validators) {
            v.validate(context, component, value);
        }
    }

    @Override
    public String getValidatorScript(FacesContext context, UIComponent component) {
        StringBuilder buf = null;
        for (Validator v : this.validators) {
            String vs;
            if (!(v instanceof ClientValidator) || (vs = ((ClientValidator)v).getValidatorScript(context, component)) == null) continue;
            if (buf == null) {
                buf = new StringBuilder();
            }
            buf.append(vs);
        }
        return buf == null ? null : buf.toString();
    }

    @Override
    public String getValidatorInstanceScript(FacesContext context, UIComponent component) {
        StringBuilder buf = null;
        for (Validator v : this.validators) {
            String vs;
            if (!(v instanceof ClientValidator) || (vs = ((ClientValidator)v).getValidatorInstanceScript(context, component)) == null) continue;
            if (buf == null) {
                buf = new StringBuilder();
            }
            if (buf.length() != 0) {
                buf.append(",");
            }
            buf.append(vs);
        }
        return buf == null ? null : buf.toString();
    }

    public Object saveState(FacesContext context) {
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public static class EmptyValueCompositeValidator
    extends CompositeValidator
    implements EmptyValueValidator {
    }
}

