/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.ConverterAdapter;
import org.operamasks.faces.binding.impl.MethodConvertAction;
import org.operamasks.faces.binding.impl.MethodFormatAction;

public final class ConverterBinding
extends Binding {
    private String[] ids;
    private Method convert;
    private Method format;

    public ConverterBinding(String viewId, String[] ids) {
        super(viewId);
        this.ids = ids;
    }

    public String[] getIds() {
        return this.ids;
    }

    public Method getConvertMethod() {
        return this.convert;
    }

    public void setConvertMethod(Method method) {
        method.setAccessible(true);
        this.convert = BindingUtils.getInterfaceMethod(method);
    }

    public Method getFormatMethod() {
        return this.format;
    }

    public void setFormatMethod(Method method) {
        method.setAccessible(true);
        this.format = BindingUtils.getInterfaceMethod(method);
    }

    public void apply(FacesContext ctx, ModelBindingContext mbc) {
        ModelBean bean = mbc.getModelBean();
        for (String id : this.ids) {
            ConverterAdapter adapter;
            UIComponent comp = mbc.getComponent(id);
            if (comp == null || !(comp instanceof ValueHolder)) continue;
            ValueHolder vh = (ValueHolder)comp;
            Converter previous = vh.getConverter();
            if (previous == null) {
                adapter = new ConverterAdapter();
                vh.setConverter((Converter)adapter);
            } else {
                if (!(previous instanceof ConverterAdapter)) continue;
                adapter = (ConverterAdapter)previous;
            }
            if (this.convert != null) {
                adapter.setConvertAction(new MethodConvertAction(bean, this.convert));
            }
            if (this.format == null) continue;
            adapter.setFormatAction(new MethodFormatAction(bean, this.format));
        }
    }

    public void applyDataItem(FacesContext ctx, ModelBindingContext mbc, UIData data) {
        if (!(this.convert != null && Modifier.isStatic(this.convert.getModifiers()) || this.format != null && Modifier.isStatic(this.format.getModifiers()))) {
            return;
        }
        for (String id : this.ids) {
            ConverterAdapter adapter;
            UIComponent comp = mbc.getComponent(id);
            if (comp == null || !(comp instanceof ValueHolder)) continue;
            ValueHolder vh = (ValueHolder)comp;
            Converter previous = vh.getConverter();
            if (previous == null) {
                adapter = new ConverterAdapter();
                vh.setConverter((Converter)adapter);
            } else {
                if (!(previous instanceof ConverterAdapter)) continue;
                adapter = (ConverterAdapter)previous;
            }
            if (this.convert != null && Modifier.isStatic(this.convert.getModifiers())) {
                adapter.setConvertAction(new MethodConvertAction(ModelBean.NULL_MODEL_BEAN, this.convert));
            }
            if (this.format == null || !Modifier.isStatic(this.format.getModifiers())) continue;
            adapter.setFormatAction(new MethodFormatAction(ModelBean.NULL_MODEL_BEAN, this.format));
        }
    }
}

