/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Annotation;
import elite.lang.Closure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.binding.ModelBinder;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.ELBinderImpl;
import org.operamasks.faces.binding.impl.ELLocalStringAttributeBinding;
import org.operamasks.faces.binding.impl.ELLocalStringBinding;
import org.operamasks.faces.binding.impl.ELPhaseListenerBinding;
import org.operamasks.faces.binding.impl.ELValueBinding;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.faces.binding.impl.processor.elbean.AnnotationProcessor;
import org.operamasks.faces.util.LoggerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ELBindingBuilder {
    private final List<Binding> bindings = new ArrayList<Binding>();
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.binding");
    private static final String BINDING_MARKER = "org.operamasks.faces.Binding";
    private static final String DEFAULT_PROCESSOR_CONFIG_FILE = "org/operamasks/faces/binding/impl/processor/elbean/elbean_processors.cfg";
    private static final String PROCESSOR_CONFIG_FILE = "META-INF/elbean_processors.cfg";
    private static List<AnnotationProcessor> processors = new ArrayList<AnnotationProcessor>();

    ELBindingBuilder() {
    }

    ModelBinder build(ELContext elctx, String path, Map<String, ValueExpression> vmap) {
        Object value;
        ClassResolver cr = ClassResolver.getInstance((ELContext)elctx);
        cr.addImport("org.operamasks.faces.annotation.*");
        for (Map.Entry<String, ValueExpression> e : vmap.entrySet()) {
            Closure c;
            if (!(e.getValue() instanceof Closure) || !this.markForCurrentPath(c = (Closure)e.getValue(), path)) continue;
            this.scan(elctx, path, e.getKey(), c);
        }
        ValueExpression ve = vmap.get("onPageLoad");
        if (ve != null && (value = ve.getValue(elctx)) instanceof Closure) {
            ELPhaseListenerBinding b = new ELPhaseListenerBinding();
            b.setOnPageLoadClosure((Closure)value);
            this.bindings.add(b);
        }
        if (path != null) {
            for (String key : ELiteBean.getLocalStringKeys(path)) {
                int i = key.indexOf(46);
                if (i == -1) continue;
                String id = key.substring(0, i);
                String att = key.substring(i + 1);
                if (!this.isValidAttribute(att)) continue;
                this.addLocalStringBinding(key, id, att);
            }
        }
        if (this.bindings.isEmpty()) {
            return null;
        }
        Collections.sort(this.bindings, new Comparator<Binding>(){

            @Override
            public int compare(Binding x, Binding y) {
                return x.getOrder() - y.getOrder();
            }
        });
        return new ELBinderImpl(this.bindings);
    }

    private boolean markForCurrentPath(Closure c, String path) {
        Annotation marker = c.getAnnotation(BINDING_MARKER);
        if (path == null) {
            return marker == null;
        }
        if (marker == null) {
            marker = new Annotation(BINDING_MARKER);
            marker.setAttribute("path", (Object)path);
            c.addAnnotation(marker);
            return true;
        }
        String markpath = (String)marker.getAttribute("path", String.class);
        return path.equals(markpath);
    }

    private void scan(ELContext ctx, String path, String name, Closure c) {
        for (AnnotationProcessor p : processors) {
            Binding b = p.process(ctx, path, name, c);
            if (b == null) continue;
            this.bindings.add(b);
            if (!p.exclusive()) continue;
            break;
        }
    }

    private void addLocalStringBinding(String key, String id, String att) {
        for (Binding b : this.bindings) {
            ELValueBinding vb;
            if (!(b instanceof ELValueBinding) || !id.equals((vb = (ELValueBinding)b).getId()) || !att.equals(vb.getAttribute())) continue;
            if (vb.getLocalString() == null) {
                vb.setLocalString(new ELLocalStringBinding(vb.getClosure(), key, vb.getType()));
            }
            return;
        }
        this.bindings.add(new ELLocalStringAttributeBinding(id, att));
    }

    private boolean isValidAttribute(String att) {
        return att.matches("[a-zA-Z][a-zA-Z0-9_]*") && !"label".equals(att) && !"description".equals(att);
    }

    private static ClassLoader getClassLoader() {
        ApplicationAssociate associate = ApplicationAssociate.getInstance();
        if (associate != null) {
            return associate.getClassLoader();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseProcessor(InputStream configStream, ClassLoader cl) {
        BufferedReader reader = null;
        try {
            String name;
            reader = new BufferedReader(new InputStreamReader(configStream));
            while ((name = reader.readLine()) != null) {
                if ((name = name.trim()).length() == 0) continue;
                Class<?> clazz = cl.loadClass(name);
                AnnotationProcessor processor = (AnnotationProcessor)clazz.newInstance();
                processors.add(processor);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "read config file fails: " + e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "load class fails: " + e);
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "instantiation fails: " + e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "illegal access: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "close stream fails: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream configStream = null;
        try {
            ClassLoader cl = ELBindingBuilder.getClassLoader();
            ArrayList<URL> configUrls = new ArrayList<URL>();
            URL default_config_url = cl.getResource(DEFAULT_PROCESSOR_CONFIG_FILE);
            configUrls.add(default_config_url);
            Enumeration<URL> urls = cl.getResources(PROCESSOR_CONFIG_FILE);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                configUrls.add(url);
            }
            for (URL url : configUrls) {
                configStream = url.openStream();
                ELBindingBuilder.parseProcessor(configStream, cl);
                if (configStream == null) continue;
                configStream.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "load config file fails: " + e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "close stream fails: " + e);
                }
            }
        }
    }
}

