/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.ELSelectItemsValueAdapter;
import org.operamasks.faces.binding.impl.ELiteBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELSelectItemsBinding
extends Binding {
    private Closure closure;
    private String name;
    private Class<?> type;
    private Object source;
    private Closure mapValue;
    private Closure mapLabel;
    private SelectItem[] items;

    public ELSelectItemsBinding(Closure closure, String name, Class<?> type) {
        super(null);
        this.closure = closure;
        this.name = name;
        this.type = type;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Closure getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(Closure mapValue) {
        this.mapValue = mapValue;
    }

    public Closure getMapLabel() {
        return this.mapLabel;
    }

    public void setMapLabel(Closure mapLabel) {
        this.mapLabel = mapLabel;
    }

    public SelectItem[] getItems() {
        return this.items;
    }

    public void setItems(SelectItem[] items) {
        this.items = items;
    }

    public void apply(UIComponent parent, ELiteBean bean) {
        String selectionId = parent.getId() + "-selectItems";
        UISelectItems selection = null;
        for (UIComponent kid : parent.getChildren()) {
            if (!(kid instanceof UISelectItems) || !selectionId.equals(kid.getId())) continue;
            selection = (UISelectItems)kid;
            break;
        }
        if (selection == null) {
            selection = new UISelectItems();
            selection.setId(selectionId);
            selection.setTransient(true);
            parent.getChildren().add(selection);
        }
        ELSelectItemsValueAdapter adapter = new ELSelectItemsValueAdapter(this, bean);
        selection.setValueExpression("value", (ValueExpression)adapter);
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        ELContext elctx = ctx.getELContext();
        if (this.closure.getValue(elctx) != null) {
            return;
        }
        SelectItem[] value = this.getValue(elctx, (ELiteBean)mbc.getModelBean());
        if (value != null) {
            this.closure.setValue(elctx, (Object)value);
        }
    }

    public SelectItem[] getValue(ELContext ctx, ELiteBean bean) {
        if (this.source != null) {
            return this.evaluateSource(ctx, this.source);
        }
        if (this.items == null || this.items.length == 0) {
            return this.loadSelectItems(bean);
        }
        return this.populateSelectItems(bean, this.items);
    }

    private SelectItem[] evaluateSource(ELContext ctx, Object source) {
        if (source instanceof Collection) {
            return this.mapListItems(ctx, (Collection)source);
        }
        if (source instanceof Object[]) {
            return this.mapArrayItems(ctx, (Object[])source);
        }
        return new SelectItem[]{this.mapSelectItem(ctx, source)};
    }

    private SelectItem[] mapListItems(ELContext ctx, Collection source) {
        SelectItem[] result = new SelectItem[source.size()];
        int i = 0;
        for (Object item : source) {
            result[i++] = this.mapSelectItem(ctx, item);
        }
        return result;
    }

    private SelectItem[] mapArrayItems(ELContext ctx, Object[] source) {
        SelectItem[] result = new SelectItem[source.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.mapSelectItem(ctx, source[i]);
        }
        return result;
    }

    private SelectItem mapSelectItem(ELContext ctx, Object item) {
        if (item instanceof SelectItem) {
            return (SelectItem)item;
        }
        if (this.mapValue == null && this.mapLabel == null) {
            return new SelectItem(item);
        }
        Object value = this.mapValue == null ? item : this.mapValue.call(ctx, new Object[]{item});
        Object label = this.mapLabel == null ? item : this.mapLabel.call(ctx, new Object[]{item});
        return new SelectItem(value, TypeCoercion.coerceToString((Object)label));
    }

    private SelectItem[] loadSelectItems(ELiteBean bean) {
        String value;
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        int i = 0;
        while ((value = this.getText(bean, i, "value")) != null) {
            String label = this.getText(bean, i, "label");
            String description = this.getText(bean, i, "description");
            if (label == null) {
                label = value;
            }
            result.add(new SelectItem((Object)value, label, description, false, false));
            ++i;
        }
        return result.toArray(new SelectItem[result.size()]);
    }

    private SelectItem[] populateSelectItems(ELiteBean bean, SelectItem[] items) {
        int count = items.length;
        SelectItem[] result = new SelectItem[count];
        for (int i = 0; i < count; ++i) {
            SelectItem item = items[i];
            Object value = item.getValue();
            String label = item.getLabel();
            String description = item.getDescription();
            if (label == null && (label = this.getText(bean, i, "label")) == null && value != null) {
                label = value.toString();
            }
            if (description == null) {
                description = this.getText(bean, i, "description");
            }
            result[i] = new SelectItem(value, label, description, item.isDisabled(), item.isEscape());
        }
        return result;
    }

    private String getText(ELiteBean bean, int index, String attribute) {
        return bean.getLocalString(this.name + ".selectItems[" + index + "]." + attribute);
    }
}

