/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectMany;
import javax.faces.component.UISelectOne;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.PhaseId;
import javax.faces.validator.Validator;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.factories.CustomizingConverterFactory;
import org.operamasks.faces.binding.factories.CustomizingValidatorFactory;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingUtils;
import org.operamasks.faces.binding.impl.ClosureValueAdapter;
import org.operamasks.faces.binding.impl.CompositeDataItemAdapter;
import org.operamasks.faces.binding.impl.CompositeValidator;
import org.operamasks.faces.binding.impl.CompositeValueAdapter;
import org.operamasks.faces.binding.impl.ConverterAdapter;
import org.operamasks.faces.binding.impl.ELLocalStringBinding;
import org.operamasks.faces.binding.impl.ELSelectItemsBinding;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.faces.internal.util.OMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELValueBinding
extends Binding {
    private Closure closure;
    private Class<?> type;
    private String id;
    private String attribute;
    private ConverterFactory converterFactory;
    private String converterMessage;
    private List<ValidatorFactory> validators;
    private boolean required;
    private String requiredMessage;
    private ELLocalStringBinding localString;
    private ELSelectItemsBinding selectItems;

    public ELValueBinding(Closure closure, Class<?> type, String id, String attribute) {
        super(null);
        this.closure = closure;
        this.type = type;
        this.id = id;
        this.attribute = attribute;
    }

    public Closure getClosure() {
        return this.closure;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public String getConverterMessage() {
        return this.converterMessage;
    }

    public void setConverterMessage(String message) {
        this.converterMessage = message;
    }

    public void addValidatorFactory(ValidatorFactory factory) {
        if (this.validators == null) {
            this.validators = new ArrayList<ValidatorFactory>();
        }
        this.validators.add(factory);
    }

    public List<ValidatorFactory> getValidatorFactories() {
        if (this.validators == null) {
            return Collections.emptyList();
        }
        return this.validators;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getRequiredMessage() {
        return this.requiredMessage;
    }

    public void setRequiredMessage(String message) {
        this.requiredMessage = message;
    }

    public ELLocalStringBinding getLocalString() {
        return this.localString;
    }

    public void setLocalString(ELLocalStringBinding binding) {
        this.localString = binding;
    }

    public ELSelectItemsBinding getSelectItems() {
        return this.selectItems;
    }

    public void setSelectItems(ELSelectItemsBinding binding) {
        this.selectItems = binding;
    }

    @Override
    public void apply(FacesContext ctx, ModelBindingContext mbc) {
        UIComponent comp = mbc.getComponent(this.id);
        if (comp == null) {
            return;
        }
        PhaseId phaseId = mbc.getPhaseId();
        ELiteBean bean = (ELiteBean)mbc.getModelBean();
        ValueExpression previous = comp.getValueExpression(this.attribute);
        if (previous instanceof CompositeDataItemAdapter) {
            return;
        }
        if (previous == null || previous instanceof CompositeValueAdapter) {
            CompositeValueAdapter adapter;
            if (previous == null || phaseId != ((CompositeValueAdapter)previous).getPhaseId()) {
                adapter = new CompositeValueAdapter();
                adapter.setPhaseId(phaseId);
                comp.setValueExpression(this.attribute, (ValueExpression)adapter);
            } else {
                adapter = (CompositeValueAdapter)previous;
            }
            ClosureValueAdapter binding = new ClosureValueAdapter(this.closure, null);
            adapter.addValueBinding(binding);
            ELContext elctx = ctx.getELContext();
            if ("binding".equals(this.attribute)) {
                UIComponent oldValue = (UIComponent)binding.getValue(elctx);
                if (oldValue != null && oldValue != comp) {
                    comp.restoreState(ctx, oldValue.saveState(ctx));
                }
                binding.setValue(elctx, comp);
            }
        }
        if ("value".equals(this.attribute) && comp instanceof ValueHolder) {
            this.applyConverter((ValueHolder)comp);
            if (comp instanceof EditableValueHolder) {
                this.applyValidators(phaseId, (EditableValueHolder)comp);
            }
        }
        if (this.selectItems != null && (comp instanceof UISelectOne || comp instanceof UISelectMany)) {
            this.selectItems.apply(comp, bean);
        }
        Set<UIComponent> labels = BindingUtils.findLabelComponent(ctx, comp);
        for (UIComponent label : labels) {
            if (label == null) continue;
            this.setText(label, bean, "label", "value");
        }
        this.setText(comp, bean, "description", "title");
    }

    private void applyConverter(ValueHolder comp) {
        Converter converter;
        ConverterFactory factory = this.converterFactory;
        if (factory == null) {
            return;
        }
        Converter previous = comp.getConverter();
        if ((previous == null || previous instanceof ConverterAdapter) && (converter = factory instanceof CustomizingConverterFactory ? ((CustomizingConverterFactory)factory).createConverter(null, this.type) : factory.createConverter(this.type)) != null) {
            ConverterAdapter adapter;
            if (previous == null) {
                adapter = new ConverterAdapter();
                comp.setConverter((Converter)adapter);
            } else {
                adapter = (ConverterAdapter)previous;
            }
            adapter.setFallback(converter);
        }
    }

    private void applyValidators(PhaseId phaseId, EditableValueHolder comp) {
        if (this.required) {
            comp.setRequired(true);
        }
        if (this.validators != null) {
            CompositeValidator composite = CompositeValidator.getCompositeValidator(comp, phaseId);
            for (ValidatorFactory vf : this.validators) {
                Validator validator = vf instanceof CustomizingValidatorFactory ? ((CustomizingValidatorFactory)vf).createValidator(null) : vf.createValidator();
                if (validator == null) continue;
                composite.addValidator(validator);
            }
        }
    }

    private void setText(UIComponent comp, ELiteBean bean, String key, String attribute) {
        if (comp.getValueExpression(attribute) == null) {
            String text = bean.getLocalString(this.id + "." + key);
            if (text == null && key.equals("label")) {
                text = OMUtils.toCamelCase(this.id);
            }
            if (text != null) {
                ValueExpression ve = BindingUtils.createValueWrapper(null, text, String.class);
                comp.setValueExpression(attribute, ve);
            }
        }
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        ELiteBean bean;
        Object value;
        if (this.localString != null && this.closure.getValue(ctx.getELContext()) == null && (value = this.localString.getValue(bean = (ELiteBean)mbc.getModelBean())) != null) {
            this.closure.setValue(ctx.getELContext(), value);
        }
    }
}

