/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.FieldValueAdapter;
import org.operamasks.faces.binding.impl.SaveStateFieldDesc;
import org.operamasks.faces.binding.impl.StateBinding;

public class FieldStateBinding
extends StateBinding {
    private Field field;

    public FieldStateBinding(String viewId, String key, Field field, boolean inServer, String timeOutAction) {
        super(viewId, key, field.getType(), inServer, timeOutAction);
        field.setAccessible(true);
        this.field = field;
    }

    protected Object getStateValue(FacesContext ctx, ModelBindingContext mbc) {
        ModelBean bean = mbc.getModelBean();
        return bean.getField(this.field);
    }

    protected void setStateValue(FacesContext ctx, ModelBindingContext mbc, Object value) {
        ModelBean bean = mbc.getModelBean();
        bean.setField(this.field, value);
    }

    protected ValueExpression createValueAdapter(FacesContext ctx, ModelBindingContext mbc) {
        ModelBean bean = mbc.getModelBean();
        return new FieldValueAdapter(bean, this.field, false);
    }

    protected void postApplyServerState(FacesContext ctx, ModelBindingContext mbc) {
        ModelBean bean = mbc.getModelBean();
        Map requestMap = ctx.getExternalContext().getRequestMap();
        ConcurrentHashMap<String, SaveStateFieldDesc> saveStateFieldDescMap = (ConcurrentHashMap<String, SaveStateFieldDesc>)requestMap.get("org.operamasks.faces.SAVE_STATE_FIELD_DESC_MAP");
        if (saveStateFieldDescMap == null) {
            saveStateFieldDescMap = new ConcurrentHashMap<String, SaveStateFieldDesc>();
            requestMap.put("org.operamasks.faces.SAVE_STATE_FIELD_DESC_MAP", saveStateFieldDescMap);
        }
        SaveStateFieldDesc desc = new SaveStateFieldDesc(this.field, bean);
        saveStateFieldDescMap.put(this.getKey(), desc);
    }

    protected void invokeTimeOutAction(FacesContext ctx, ModelBindingContext mbc) {
        MethodExpression me = ctx.getApplication().getExpressionFactory().createMethodExpression(ctx.getELContext(), this.getTimeOutAction(), Void.TYPE, new Class[]{String.class, String.class});
        me.invoke(ctx.getELContext(), new Object[]{mbc.getModelBean().getNames()[0], this.field.getName()});
    }
}

