/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.binding.impl.SelectItemsValueAdapter;
import org.operamasks.faces.binding.impl.ValueWrapper;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SelectItemsBinding
extends PropertyBinding {
    private String source;
    private String mapValue;
    private String mapLabel;
    private SelectItem[] items;
    private Class<?> valueClass;
    private Map<Locale, Object> cachedValue = new ConcurrentHashMap<Locale, Object>();

    public SelectItemsBinding(String viewId) {
        super(viewId);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        if (source != null && source.length() == 0) {
            source = null;
        }
        this.source = source;
    }

    public String getMapValue() {
        return this.mapValue;
    }

    public void setMapValue(String mapValue) {
        if (mapValue != null && mapValue.length() == 0) {
            mapValue = null;
        }
        this.mapValue = mapValue;
    }

    public String getMapLabel() {
        return this.mapLabel;
    }

    public void setMapLabel(String mapLabel) {
        if (mapLabel != null && mapLabel.length() == 0) {
            mapLabel = null;
        }
        this.mapLabel = mapLabel;
    }

    public SelectItem[] getItems() {
        return this.items;
    }

    public void setItems(SelectItem[] items) {
        this.items = items;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class valueClass) {
        this.valueClass = valueClass;
    }

    public void apply(UIComponent parent, ModelBean bean) {
        String selectionId = parent.getId() + "-selectItems";
        UISelectItems selection = null;
        for (UIComponent kid : parent.getChildren()) {
            if (!(kid instanceof UISelectItems) || !selectionId.equals(kid.getId())) continue;
            selection = (UISelectItems)kid;
            break;
        }
        if (selection == null) {
            selection = new UISelectItems();
            selection.setId(selectionId);
            selection.setTransient(true);
            parent.getChildren().add(selection);
        }
        selection.setValueExpression("value", (ValueExpression)new SelectItemsValueAdapter(this, bean));
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        ModelBean bean = mbc.getModelBean();
        if (this.getModelValue(bean) != null) {
            return;
        }
        Object value = this.getValue(bean);
        if (value != null) {
            if (this.type == SelectItem[].class) {
                if (value instanceof List) {
                    value = ((List)value).toArray(new SelectItem[((List)value).size()]);
                } else if (!(value instanceof SelectItem[])) {
                    throw new ClassCastException(value.getClass().getName());
                }
            } else if (this.type == List.class) {
                if (value instanceof SelectItem[]) {
                    value = Arrays.asList((SelectItem[])value);
                } else if (!(value instanceof List)) {
                    throw new ClassCastException(value.getClass().getName());
                }
            }
            this.setModelValue(bean, value);
        }
    }

    public Object getValue(ModelBean bean) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (this.source != null) {
            return this.evaluateSource(ctx, bean, this.source);
        }
        Locale locale = ctx.getViewRoot().getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.cachedValue.get(locale) != null) {
            return this.cachedValue.get(locale);
        }
        if (this.items.length == 0) {
            if (this.valueClass.isEnum()) {
                return this.loadEnumItems(locale, this.valueClass);
            }
            return this.loadSelectItems(locale, bean);
        }
        return this.populateSelectItems(locale, bean);
    }

    private Object evaluateSource(FacesContext ctx, ModelBean bean, String expr) {
        Object source = bean.evaluateExpression(expr, Object.class);
        if (source == null) {
            return null;
        }
        if (source instanceof Collection) {
            return this.mapListItems(ctx, bean, (Collection)source);
        }
        if (source.getClass().isArray()) {
            return this.mapArrayItems(ctx, bean, (Object[])source);
        }
        if (source instanceof Enum) {
            return this.mapEnumItem((Enum)source);
        }
        if (source instanceof Enum[]) {
            return this.mapEnumItems((Enum[])source);
        }
        return this.mapSelectItem(ctx, bean, source);
    }

    private SelectItem[] mapListItems(FacesContext ctx, ModelBean bean, Collection source) {
        SelectItem[] result = new SelectItem[source.size()];
        int i = 0;
        for (Object item : source) {
            result[i++] = this.mapSelectItem(ctx, bean, item);
        }
        return result;
    }

    private SelectItem[] mapArrayItems(FacesContext ctx, ModelBean bean, Object[] source) {
        SelectItem[] result = new SelectItem[source.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.mapSelectItem(ctx, bean, source[i]);
        }
        return result;
    }

    private SelectItem mapSelectItem(FacesContext ctx, ModelBean bean, Object item) {
        if (item instanceof SelectItem) {
            return this.populateSelectItem(bean, (SelectItem)item);
        }
        if (this.mapValue == null && this.mapLabel == null) {
            return this.populateSelectItem(bean, new SelectItem(item));
        }
        VariableMapper varMapper = ctx.getELContext().getVariableMapper();
        ValueExpression oldVar = varMapper.setVariable("item", (ValueExpression)new ValueWrapper(item, Object.class));
        Object value = this.mapValue != null ? bean.evaluateExpression(this.mapValue, Object.class) : item;
        String label = this.mapLabel != null ? bean.evaluateExpression(this.mapLabel, String.class) : (value == null ? null : value.toString());
        varMapper.setVariable("item", oldVar);
        return this.populateSelectItem(bean, new SelectItem(value, label));
    }

    private SelectItem populateSelectItem(ModelBean bean, SelectItem selectItem) {
        if (selectItem == null) {
            return null;
        }
        Object value = selectItem.getValue();
        String label = selectItem.getLabel();
        if (value instanceof String && FacesUtils.isValueExpression((String)value)) {
            value = bean.evaluateExpression((String)value, this.valueClass);
        }
        if (FacesUtils.isValueExpression(label)) {
            label = bean.evaluateExpression(label, String.class);
        }
        if (label == null && value != null) {
            label = value.toString();
        }
        return new SelectItem(value, label);
    }

    private SelectItem mapEnumItem(Enum<?> source) {
        String name = source.name();
        String label = OMUtils.getLocalString(source.getClass(), name + ".label");
        if (label == null && (label = OMUtils.getLocalString(this.getDeclaringClass(), source.getClass().getName() + "." + name + ".label")) == null) {
            label = source.toString();
        }
        return new SelectItem(source, label);
    }

    private SelectItem[] mapEnumItems(Enum<?>[] source) {
        SelectItem[] result = new SelectItem[source.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.mapEnumItem(source[i]);
        }
        return result;
    }

    private SelectItem[] loadEnumItems(Locale locale, Class<? extends Enum> enumClass) {
        SelectItem[] result = this.mapEnumItems(enumClass.getEnumConstants());
        this.cachedValue.put(locale, result);
        return result;
    }

    private List<SelectItem> loadSelectItems(Locale locale, ModelBean bean) {
        String value;
        ArrayList<SelectItem> result = new ArrayList<SelectItem>();
        boolean cacheable = true;
        int i = 0;
        while ((value = this.getText(i, "value")) != null) {
            String description;
            String label;
            if (FacesUtils.isValueExpression(value)) {
                value = bean.evaluateExpression(value, this.valueClass);
                cacheable = false;
            }
            if (FacesUtils.isValueExpression(label = this.getText(i, "label"))) {
                label = bean.evaluateExpression(label, String.class);
                cacheable = false;
            }
            if (label == null && value != null) {
                label = value.toString();
            }
            if (FacesUtils.isValueExpression(description = this.getText(i, "description"))) {
                description = bean.evaluateExpression(description, String.class);
                cacheable = false;
            }
            result.add(new SelectItem((Object)value, label, description, false, false));
            ++i;
        }
        if (cacheable) {
            this.cachedValue.put(locale, result);
        }
        return result;
    }

    private SelectItem[] populateSelectItems(Locale locale, ModelBean bean) {
        int count = this.items.length;
        SelectItem[] result = new SelectItem[count];
        boolean cacheable = true;
        for (int i = 0; i < count; ++i) {
            String description;
            String label;
            SelectItem item = this.items[i];
            Object value = item.getValue();
            if (FacesUtils.isValueExpression((String)value)) {
                value = bean.evaluateExpression((String)value, this.valueClass);
                cacheable = false;
            }
            if ((label = item.getLabel()) == null || label.length() == 0) {
                label = this.getText(i, "label");
            }
            if (FacesUtils.isValueExpression(label)) {
                label = bean.evaluateExpression(label, String.class);
                cacheable = false;
            }
            if (label == null && value != null) {
                label = value.toString();
            }
            if ((description = item.getDescription()) == null || description.length() == 0) {
                description = this.getText(i, "description");
            }
            if (FacesUtils.isValueExpression(description)) {
                description = bean.evaluateExpression(description, String.class);
                cacheable = false;
            }
            result[i] = new SelectItem(value, label, description, item.isDisabled(), item.isEscape());
        }
        if (cacheable) {
            this.cachedValue.put(locale, result);
        }
        return result;
    }

    private String getText(int index, String attribute) {
        return OMUtils.getLocalString(this.getDeclaringClass(), this.getName() + ".selectItems[" + index + "]." + attribute);
    }
}

