/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.operamasks.faces.application.impl.StateManagerImpl;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.component.misc.UIHiddenState;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.user.util.Browser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StateBinding
extends Binding {
    private String key;
    private Class<?> type;
    private boolean inServer;
    private String timeOutAction;
    private static final String HIDDEN_STATE_ID = "j_id_savestate";
    private static final String HIDDEN_STATE_PREFIX = "j_id_state_";
    public static final String SERVER_STATE_KEY = "org.operamasks.faces.SERVER_MODEL_STATE";
    public static final String SAVE_STATE_FIELD_DESC_MAP = "org.operamasks.faces.SAVE_STATE_FIELD_DESC_MAP";
    private static final String REFRASHED_KEY = "operamasks.savestate.timeout.refresh";
    Logger logger = Logger.getLogger("org.operamasks.faces.conversation");
    private static final String[] encodableTypes = new String[]{"byte", "char", "short", "int", "long", "float", "double", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.math.BigInteger", "java.math.BigDecimal", "java.util.Date", "java.lang.String"};

    public String getKey() {
        return this.key;
    }

    StateBinding(String viewId, String key, Class<?> type, boolean inServer, String timeOutAction) {
        super(viewId);
        this.key = key;
        this.type = type == null ? Object.class : type;
        this.inServer = inServer;
        this.timeOutAction = timeOutAction;
    }

    public boolean isSavingStateInServer(FacesContext ctx) {
        return this.inServer || !ctx.getApplication().getStateManager().isSavingStateInClient(ctx);
    }

    protected abstract Object getStateValue(FacesContext var1, ModelBindingContext var2);

    protected abstract void setStateValue(FacesContext var1, ModelBindingContext var2, Object var3);

    protected abstract ValueExpression createValueAdapter(FacesContext var1, ModelBindingContext var2);

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        if (this.isSavingStateInServer(ctx)) {
            this.applyServerState(ctx, mbc);
        } else if (StateBinding.isEncodable(this.type)) {
            this.applyClientState(ctx, mbc);
        } else {
            this.applyAttachedState(ctx, mbc);
        }
    }

    protected void postApplyServerState(FacesContext ctx, ModelBindingContext mbc) {
    }

    private void applyServerState(FacesContext ctx, ModelBindingContext mbc) {
        PhaseId phaseId = mbc.getPhaseId();
        try {
            if (phaseId == PhaseId.RESTORE_VIEW) {
                Map stateMap = this.getServerStateMap(ctx);
                if (stateMap != null && stateMap.containsKey(this.key)) {
                    this.setStateValue(ctx, mbc, stateMap.get(this.key));
                }
                if (stateMap == null && this.isLookingUpCid(ctx)) {
                    this.handleTimeOut(ctx, mbc);
                }
            } else if (phaseId == PhaseId.RENDER_RESPONSE) {
                Map params = ctx.getExternalContext().getRequestParameterMap();
                if (params.containsKey("__view_delegate_request__")) {
                    Map stateMap = this.getServerStateMap(ctx);
                    if (stateMap != null && stateMap.containsKey(this.key)) {
                        this.setStateValue(ctx, mbc, stateMap.get(this.key));
                    }
                    if (stateMap == null && this.isLookingUpCid(ctx)) {
                        this.handleTimeOut(ctx, mbc);
                    }
                }
                this.postApplyServerState(ctx, mbc);
            }
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private void handleTimeOut(FacesContext ctx, ModelBindingContext mbc) {
        this.logger.log(Level.FINER, "Conversation scope of ID [" + (String)ctx.getExternalContext().getRequestParameterMap().get("jconversationid") + "] is time out.");
        if (this.timeOutAction == null || this.timeOutAction.trim().length() == 0 || this.timeOutAction.equalsIgnoreCase("Ignore")) {
            return;
        }
        if ("Exception".equalsIgnoreCase(this.timeOutAction)) {
            throw new FacesException("Conversation scope of ID [" + (String)ctx.getExternalContext().getRequestParameterMap().get("jconversationid") + "] is time out.");
        }
        if ("Refresh".equalsIgnoreCase(this.timeOutAction)) {
            Map reqMap = ctx.getExternalContext().getRequestMap();
            if (!reqMap.containsKey(REFRASHED_KEY)) {
                Browser.execClientScript("document.location.reload();");
                reqMap.put(REFRASHED_KEY, true);
                ctx.renderResponse();
            }
        } else if (FacesUtils.isValueExpression(this.timeOutAction)) {
            this.timeOutAction = this.timeOutAction.replace("this.", mbc.getModelBean().getNames()[0] + ".");
            this.invokeTimeOutAction(ctx, mbc);
        }
    }

    protected void invokeTimeOutAction(FacesContext ctx, ModelBindingContext mbc) {
        MethodExpression me = ctx.getApplication().getExpressionFactory().createMethodExpression(ctx.getELContext(), this.timeOutAction, Void.TYPE, new Class[]{String.class});
        me.invoke(ctx.getELContext(), new Object[]{mbc.getModelBean().getNames()[0]});
    }

    private boolean isLookingUpCid(FacesContext ctx) {
        boolean isLookingUp = ctx.getExternalContext().getRequestParameterMap().containsKey("jconversationid");
        return isLookingUp;
    }

    private Map getServerStateMap(FacesContext ctx) {
        ConversationContext cctx = ConversationContext.getCurrentInstance();
        Map stateMap = (Map)cctx.get(SERVER_STATE_KEY);
        return stateMap;
    }

    private void applyClientState(FacesContext ctx, ModelBindingContext mbc) {
        PhaseId phaseId = mbc.getPhaseId();
        UIHiddenState hidden = null;
        for (UIComponent kid : ctx.getViewRoot().getChildren()) {
            if (!(kid instanceof UIHiddenState)) continue;
            hidden = (UIHiddenState)kid;
            break;
        }
        if (hidden == null) {
            hidden = new UIHiddenState();
            hidden.setId(HIDDEN_STATE_ID);
            hidden.setPhaseId(phaseId);
            hidden.setTransient(true);
            ctx.getViewRoot().getChildren().add(0, hidden);
        } else if (phaseId != hidden.getPhaseId()) {
            hidden.clearAttachedStates();
            hidden.setPhaseId(phaseId);
        }
        String name = HIDDEN_STATE_PREFIX + this.key;
        ValueExpression binding = this.createValueAdapter(ctx, mbc);
        hidden.addAttachedState(name, binding);
    }

    private void applyAttachedState(FacesContext ctx, ModelBindingContext mbc) {
        PhaseId phaseId = mbc.getPhaseId();
        try {
            Object value;
            if (phaseId == PhaseId.RESTORE_VIEW) {
                Object value2 = StateManagerImpl.restoreAttachedState(ctx, this.key);
                if (value2 != null) {
                    this.setStateValue(ctx, mbc, value2);
                }
            } else if (phaseId == PhaseId.RENDER_RESPONSE && (value = this.getStateValue(ctx, mbc)) != null) {
                StateManagerImpl.saveAttachedState(ctx, this.key, value);
            }
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private static boolean isEncodable(Class<?> type) {
        if (type == null) {
            return false;
        }
        return Arrays.binarySearch(encodableTypes, type.getName()) >= 0;
    }

    public String getTimeOutAction() {
        return this.timeOutAction;
    }

    static {
        Arrays.sort(encodableTypes);
    }
}

