/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl.processor.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.faces.component.UIComponent;
import org.operamasks.faces.annotation.Bind;
import org.operamasks.faces.annotation.Description;
import org.operamasks.faces.annotation.Label;
import org.operamasks.faces.annotation.LocalString;
import org.operamasks.faces.annotation.RequestParam;
import org.operamasks.faces.annotation.Required;
import org.operamasks.faces.annotation.SelectItems;
import org.operamasks.faces.annotation.Validator;
import org.operamasks.faces.annotation.Validators;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.LocalStringBinding;
import org.operamasks.faces.binding.impl.RequestParamBinding;
import org.operamasks.faces.binding.impl.SelectItemsBinding;
import org.operamasks.faces.binding.impl.ValueBinding;
import org.operamasks.faces.binding.impl.processor.bean.AnnotationProcessor;
import org.operamasks.faces.binding.impl.processor.bean.LocalStringProcessor;
import org.operamasks.faces.binding.impl.processor.bean.ProcessorUtils;
import org.operamasks.faces.binding.impl.processor.bean.RequestParamProcessor;
import org.operamasks.faces.binding.impl.processor.bean.SelectItemsProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindProcessor
extends AnnotationProcessor<Bind> {
    public BindProcessor() {
        super(Bind.class);
    }

    @Override
    protected Binding build(Bind meta, Class<?> targetClass, AnnotatedElement f) {
        ValueBinding b = new ValueBinding(meta.view());
        b.init(Bind.class, targetClass, f);
        String id = meta.id();
        String attribute = meta.attribute();
        String expr = meta.value();
        if (id == null || id.length() == 0) {
            id = b.getName();
        }
        if (attribute == null || attribute.length() == 0) {
            attribute = UIComponent.class.isAssignableFrom(b.getType()) ? "binding" : "value";
        }
        if (expr != null && expr.length() == 0) {
            expr = null;
        }
        b.setId(id);
        b.setAttribute(attribute);
        b.setExpression(expr);
        b.setOrder(meta.order());
        this.scanDescriptiveInformation(b, targetClass, f);
        this.scanConverterAndValidators(b, f);
        this.scanRequestParam(b, targetClass, f);
        this.scanSelectItems(b, f);
        return b;
    }

    private void scanDescriptiveInformation(ValueBinding b, Class<?> targetClass, AnnotatedElement f) {
        LocalString ls;
        Description desc;
        Label label = f.getAnnotation(Label.class);
        if (label != null) {
            b.setLabel(label.value());
        }
        if ((desc = f.getAnnotation(Description.class)) != null) {
            b.setDescription(desc.value());
        }
        if ((ls = f.getAnnotation(LocalString.class)) != null) {
            LocalStringProcessor lsp = new LocalStringProcessor();
            LocalStringBinding lsb = (LocalStringBinding)lsp.build(ls, targetClass, f);
            b.setLocalString(lsb);
            String key = ls.key();
            if (key == null || key.length() == 0) {
                key = b.getId() + "." + b.getAttribute();
            }
            lsb.setKey(key);
        }
    }

    private void scanConverterAndValidators(ValueBinding b, AnnotatedElement f) {
        Required required;
        for (Annotation a : f.getAnnotations()) {
            ValidatorFactory vf;
            ConverterFactory cf = ProcessorUtils.createConverterFactory(a);
            if (cf != null) {
                b.setConverterFactory(cf);
                b.setConverterMessage(ProcessorUtils.getConverterMessage(a));
            }
            if ((vf = ProcessorUtils.createValidatorFactory(a)) == null) continue;
            b.addValidatorFactory(vf);
        }
        Validators validators = f.getAnnotation(Validators.class);
        if (validators != null) {
            for (Validator v : validators.value()) {
                b.addValidatorFactory(ProcessorUtils.createValidatorFactory(v));
            }
        }
        if ((required = f.getAnnotation(Required.class)) != null) {
            b.setRequired(true);
            b.setRequiredMessage(required.message());
        }
    }

    private void scanRequestParam(ValueBinding b, Class<?> targetClass, AnnotatedElement f) {
        RequestParam meta = f.getAnnotation(RequestParam.class);
        if (meta == null) {
            return;
        }
        RequestParamProcessor rpp = new RequestParamProcessor();
        RequestParamBinding rpb = (RequestParamBinding)rpp.build(meta, targetClass, f);
        b.setRequestParam(rpb);
    }

    private void scanSelectItems(ValueBinding b, AnnotatedElement f) {
        SelectItems meta = f.getAnnotation(SelectItems.class);
        if (meta == null) {
            return;
        }
        SelectItemsBinding sel = new SelectItemsBinding(b.getViewId());
        sel.setName(b.getName());
        sel.setType(b.getType());
        sel.setDeclaringClass(b.getDeclaringClass());
        SelectItemsProcessor.scanSelectItems(sel, meta);
        sel.setValueClass(b.getType());
        b.setSelectItems(sel);
    }
}

