/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl.processor.elbean;

import elite.lang.Annotation;
import elite.lang.Closure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.faces.model.SelectItem;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.faces.annotation.Converter;
import org.operamasks.faces.annotation.Validator;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.ConverterRegistry;
import org.operamasks.faces.application.ValidatorFactory;
import org.operamasks.faces.application.ValidatorRegistry;
import org.operamasks.faces.binding.factories.CustomizingConverterFactory;
import org.operamasks.faces.binding.factories.CustomizingValidatorFactory;
import org.operamasks.faces.binding.impl.ELSelectItemsBinding;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorUtils {
    static ConverterFactory createConverterFactory(ELContext ctx, Annotation a) {
        if (a.getAnnotationType().equals("Converter")) {
            String id = (String)a.getAttribute("id", String.class);
            Class type = (Class)a.getAttribute("value", Class.class);
            return ProcessorUtils.createConverterFactory(id, type);
        }
        try {
            ClassResolver cr = ClassResolver.getInstance((ELContext)ctx);
            Class at = cr.resolveClass(a.getAnnotationType());
            if (at.isAnnotation() && at.isAnnotationPresent(Converter.class)) {
                Converter conv = at.getAnnotation(Converter.class);
                ConverterFactory factory = ProcessorUtils.createConverterFactory(conv.id(), conv.value());
                CustomizingConverterFactory custom = new CustomizingConverterFactory(factory);
                for (Map.Entry e : a.getAttributes().entrySet()) {
                    if ("message".equals(e.getKey())) continue;
                    custom.setConverterProperty((String)e.getKey(), e.getValue());
                }
                return custom;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static ConverterFactory createConverterFactory(String id, Class<?> type) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        if (id != null && id.length() != 0) {
            ConverterFactory factory = registry.getConverterFactory(id);
            if (factory == null) {
                throw new FacesException(Resources._T("JSF_NO_SUCH_CONVERTER_ID", id));
            }
            return factory;
        }
        return registry.createConverterFactory(type);
    }

    static ValidatorFactory createValidatorFactory(ELContext ctx, Annotation a) {
        if (a.getAnnotationType().equals("Validator")) {
            String id = (String)a.getAttribute("id", String.class);
            Class type = (Class)a.getAttribute("value", Class.class);
            return ProcessorUtils.createValidatorFactory(id, type);
        }
        try {
            ClassResolver cr = ClassResolver.getInstance((ELContext)ctx);
            Class at = cr.resolveClass(a.getAnnotationType());
            if (at.isAnnotation() && at.isAnnotationPresent(Validator.class)) {
                Validator val = at.getAnnotation(Validator.class);
                ValidatorFactory factory = ProcessorUtils.createValidatorFactory(val.id(), val.value());
                CustomizingValidatorFactory custom = new CustomizingValidatorFactory(factory);
                for (Map.Entry e : a.getAttributes().entrySet()) {
                    custom.setValidatorProperty((String)e.getKey(), e.getValue());
                }
                return custom;
            }
            return null;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    static ValidatorFactory createValidatorFactory(String id, Class<?> type) {
        ValidatorRegistry registry = ValidatorRegistry.getInstance();
        if (id != null && id.length() != 0) {
            ValidatorFactory factory = registry.getValidatorFactory(id);
            if (factory == null) {
                throw new FacesException(Resources._T("JSF_NO_SUCH_VALIDATOR_ID", id));
            }
            return factory;
        }
        return registry.createValidatorFactory(type);
    }

    static void scanSelectItems(ELSelectItemsBinding b, Annotation meta) {
        Object[] meta_items = meta.getAttribute("value");
        if (meta_items instanceof List) {
            meta_items = ((List)meta_items).toArray();
        }
        if (meta_items instanceof Object[]) {
            Object[] array = meta_items;
            int count = array.length;
            SelectItem[] items = new SelectItem[count];
            for (int i = 0; i < count; ++i) {
                if (array[i] instanceof Annotation) {
                    Annotation meta_item = (Annotation)array[i];
                    SelectItem item = new SelectItem();
                    item.setValue(meta_item.getAttribute("value", String.class));
                    item.setLabel((String)meta_item.getAttribute("label", String.class));
                    item.setDescription((String)meta_item.getAttribute("description", String.class));
                    item.setDisabled(((Boolean)meta_item.getAttribute("disabled", Boolean.TYPE)).booleanValue());
                    item.setEscape(((Boolean)meta_item.getAttribute("escape", Boolean.TYPE)).booleanValue());
                    items[i] = item;
                    continue;
                }
                items[i] = new SelectItem(array[i], null);
            }
            b.setItems(items);
        }
        b.setSource(meta.getAttribute("source"));
        b.setMapValue((Closure)meta.getAttribute("mapValue", Closure.class));
        b.setMapLabel((Closure)meta.getAttribute("mapLabel", Closure.class));
    }

    static String[] getIds(Object att, String name, String prefix) {
        String[] ids = null;
        if (att != null) {
            if (att instanceof String) {
                ids = new String[]{(String)att};
            } else if (att instanceof Collection) {
                Object[] a = ((Collection)att).toArray();
                ids = new String[a.length];
                System.arraycopy(a, 0, ids, 0, a.length);
            } else if (att instanceof Object[]) {
                Object[] a = (Object[])att;
                ids = new String[a.length];
                System.arraycopy(a, 0, ids, 0, a.length);
            }
        } else if (name.startsWith(prefix)) {
            if ((name = name.substring(prefix.length())).length() == 0) {
                return null;
            }
            name = name.charAt(0) == '_' ? name.substring(1) : Character.toLowerCase(name.charAt(0)) + name.substring(1);
            ids = new String[]{name};
        }
        return ids;
    }
}

