/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.component;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.operamasks.faces.annotation.cache.AnnotationCache;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.component.ComponentConfig;
import org.operamasks.faces.component.ComponentFactory;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalComponentFactory
implements ComponentFactory {
    protected ComponentConfig config;
    protected ClassLoader loader;
    protected Class<? extends UIComponent> componentClass;
    private AnnotationCache metaCache;

    public NormalComponentFactory(ComponentConfig config) {
        this.config = config;
        ApplicationAssociate assoc = ApplicationAssociate.getInstance();
        this.loader = assoc.getClassLoader();
    }

    @Override
    public ComponentConfig getConfig() {
        return this.config;
    }

    @Override
    public UIComponent createComponent() {
        this.loadClassIfNeeded();
        UIComponent component = null;
        try {
            component = this.createComponentInstance();
            if (this.metaCache == null) {
                this.metaCache = AnnotationCache.getInstance();
            }
            this.metaCache.add(this.componentClass);
            return component;
        }
        catch (Exception ex) {
            throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", this.componentClass.getName()), (Throwable)ex);
        }
    }

    protected UIComponent createComponentInstance() throws Exception {
        return this.componentClass.newInstance();
    }

    @Override
    public void destroyComponent(UIComponent component) {
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public Class<? extends UIComponent> getComponentClass() {
        return this.componentClass;
    }

    private void loadClassIfNeeded() {
        if (this.componentClass == null) {
            try {
                this.componentClass = Utils.findClass((String)this.config.getComponentClass(), (ClassLoader)this.loader);
            }
            catch (ClassNotFoundException ex) {
                throw new FacesException(Resources._T("JSF_CREATE_COMPONENT_ERROR", this.config.getComponentType()), (Throwable)ex);
            }
        }
    }
}

