/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanConfig {
    private String name;
    private String className;
    private ManagedBeanScope scope = ManagedBeanScope.NONE;
    private String displayName;
    private String description;
    private List<Property> properties = new ArrayList<Property>();
    private List<EventListener> listeners = new ArrayList<EventListener>();
    private List<FactoryMethod> factories = new ArrayList<FactoryMethod>();
    private MapEntries mapEntries;
    private ListEntries listEntries;

    public String getManagedBeanName() {
        return this.name;
    }

    public void setManagedBeanName(String name) {
        this.name = name;
    }

    public String getManagedBeanClass() {
        return this.className;
    }

    public void setManagedBeanClass(String className) {
        this.className = className;
    }

    public ManagedBeanScope getManagedBeanScope() {
        return this.scope;
    }

    public void setManagedBeanScope(ManagedBeanScope scope) {
        this.scope = scope;
    }

    public void setManagedBeanScope(String scope) {
        if (scope == null || scope.equals("none")) {
            this.scope = ManagedBeanScope.NONE;
        } else if (scope.equals("request")) {
            this.scope = ManagedBeanScope.REQUEST;
        } else if (scope.equals("session")) {
            this.scope = ManagedBeanScope.SESSION;
        } else if (scope.equals("application")) {
            this.scope = ManagedBeanScope.APPLICATION;
        } else if (scope.equals("conversation")) {
            this.scope = ManagedBeanScope.CONVERSATION;
        } else {
            throw new IllegalArgumentException(Resources._T("JSF_INVALID_MANAGED_BEAN_SCOPE", scope));
        }
    }

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.name;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Property> getManagedProperties() {
        return this.properties;
    }

    public Property getManagedProperty(String name) {
        for (Property p : this.properties) {
            if (!name.equals(p.getPropertyName())) continue;
            return p;
        }
        return null;
    }

    public void addManagedProperty(Property property) {
        if (this.getManagedProperty(property.getPropertyName()) == null) {
            this.properties.add(property);
        }
    }

    public List<EventListener> getEventListeners() {
        return this.listeners;
    }

    public void addEventListener(EventListener listener) {
        for (EventListener l : this.listeners) {
            if (!l.listenerMethod.equals(listener.listenerMethod)) continue;
            return;
        }
        this.listeners.add(listener);
    }

    public List<FactoryMethod> getFactoryMethods() {
        return this.factories;
    }

    public void addFactoryMethod(FactoryMethod factory) {
        for (FactoryMethod f : this.factories) {
            if (!f.factoryName.equals(factory.factoryName)) continue;
            return;
        }
        this.factories.add(factory);
    }

    public MapEntries getMapEntries() {
        return this.mapEntries;
    }

    public void setMapEntries(MapEntries mapEntries) {
        this.mapEntries = mapEntries;
    }

    public ListEntries getListEntries() {
        return this.listEntries;
    }

    public void setListEntries(ListEntries listEntries) {
        this.listEntries = listEntries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListEntries {
        private String valueClass;
        private List<String> values = new ArrayList<String>();

        public String getValueClass() {
            return this.valueClass;
        }

        public void setValueClass(String valueClass) {
            if (valueClass == null) {
                valueClass = "java.lang.String";
            }
            this.valueClass = valueClass;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void addValue(String value) {
            this.values.add(value);
        }
    }

    public static class MapEntry {
        private String key;
        private String value;

        public MapEntry() {
        }

        public MapEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapEntries {
        private String keyClass;
        private String valueClass;
        private List<MapEntry> entries = new ArrayList<MapEntry>();

        public String getKeyClass() {
            return this.keyClass;
        }

        public void setKeyClass(String keyClass) {
            if (keyClass == null) {
                keyClass = "java.lang.String";
            }
            this.keyClass = keyClass;
        }

        public String getValueClass() {
            return this.valueClass;
        }

        public void setValueClass(String valueClass) {
            if (valueClass == null) {
                valueClass = "java.lang.String";
            }
            this.valueClass = valueClass;
        }

        public List<MapEntry> getMapEntries() {
            return this.entries;
        }

        public void addMapEntry(MapEntry entry) {
            this.entries.add(entry);
        }

        public void addMapEntry(String key, String value) {
            this.entries.add(new MapEntry(key, value));
        }
    }

    public static class FactoryMethod
    extends ManagedBeanConfig {
        private String factoryName;
        private Method method;

        public String getFactoryName() {
            return this.factoryName;
        }

        public void setFactoryName(String name) {
            this.factoryName = name;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public Method getMethod(Class targetClass) {
            if (targetClass != null && this.method != null) {
                this.method = Utils.checkMethod((Class)targetClass, (Method)this.method);
            }
            return this.method;
        }
    }

    public static class EventListener {
        private String[] eventTypes;
        private Method listenerMethod;

        public String[] getEventTypes() {
            return this.eventTypes;
        }

        public void setEventTypes(String[] eventTypes) {
            this.eventTypes = eventTypes;
        }

        public Method getListenerMethod() {
            return this.listenerMethod;
        }

        public void setListenerMethod(Method method) {
            this.listenerMethod = method;
        }
    }

    public static class Property {
        private String propertyName;
        private String propertyClass;
        private Field field;
        private String value;
        private MapEntries mapEntries;
        private ListEntries listEntries;

        public Property() {
        }

        public Property(String name, String type) {
            this.propertyName = name;
            this.propertyClass = type;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String name) {
            this.propertyName = name;
        }

        public String getPropertyClass() {
            return this.propertyClass;
        }

        public void setPropertyClass(String clazz) {
            this.propertyClass = clazz;
        }

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public MapEntries getMapEntries() {
            return this.mapEntries;
        }

        public void setMapEntries(MapEntries mapEntries) {
            this.mapEntries = mapEntries;
        }

        public ListEntries getListEntries() {
            return this.listEntries;
        }

        public void setListEntries(ListEntries listEntries) {
            this.listEntries = listEntries;
        }

        public Field checkAndGetField(Class targetClass) {
            if (targetClass != null && this.field != null) {
                this.field = Utils.checkField((Class)targetClass, (Field)this.field);
            }
            if (this.field != null) {
                this.field.setAccessible(true);
            }
            return this.field;
        }
    }
}

