/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.conversation;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import javax.faces.context.FacesContext;
import org.operamasks.faces.conversation.ConversationContextManager;
import org.operamasks.faces.conversation.ConversationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationContext {
    private String id;
    private Map<String, Object> paramsMap;
    private Future<?> terminationHandler;
    private Map<String, Object> viewStateMap;

    public static ConversationContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        ConversationContext cctx = null;
        String cid = ConversationHelper.getCurrentCid(context);
        ConversationContextManager cctxManager = ConversationHelper.getCctxManager(context);
        if (cctxManager != null) {
            cctx = cctxManager.getCctxMap().get(cid);
        }
        assert (cctx != null);
        return cctx;
    }

    public ConversationContext() {
        this.paramsMap = new HashMap<String, Object>();
        this.viewStateMap = new HashMap<String, Object>();
    }

    public ConversationContext(String id) {
        this.id = id;
        this.paramsMap = new HashMap<String, Object>();
        this.viewStateMap = new HashMap<String, Object>();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Future<?> getTerminationHandler() {
        return this.terminationHandler;
    }

    public void put(String key, Object value) {
        this.paramsMap.put(key, value);
    }

    public Object get(String key) {
        return this.paramsMap.get(key);
    }

    public void setTerminationHandler(Future<?> terminationHandler) {
        this.terminationHandler = terminationHandler;
    }

    public boolean cancelTermination() {
        if (this.terminationHandler.isCancelled()) {
            return true;
        }
        boolean success = this.terminationHandler.cancel(false);
        return success;
    }

    public Map<String, Object> getConversationMap() {
        return this.paramsMap;
    }

    public void putViewState(String key, Object viewState) {
        this.viewStateMap.put(key, viewState);
    }

    public Object getViewState(String key) {
        return this.viewStateMap.get(key);
    }

    public void clearViewStateMap() {
        this.viewStateMap.clear();
    }
}

