/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.conversation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.application.ManagedBeanContainer;
import org.operamasks.faces.application.ManagedBeanFactory;
import org.operamasks.faces.conversation.ConversationContext;
import org.operamasks.faces.conversation.ThreadScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationContextManager {
    private static final long DEFAULT_CONVERSATION_TIMEOUT = 120L;
    private Map<String, ConversationContext> cctxMap;
    Logger logger = Logger.getLogger("org.operamasks.faces.conversation");

    public ConversationContextManager() {
        this.cctxMap = new ConcurrentHashMap<String, ConversationContext>();
    }

    public Map<String, ConversationContext> getCctxMap() {
        return this.cctxMap;
    }

    public void beginOrRestoreCctx(String cid) {
        ConversationContext cctx = this.cctxMap.get(cid);
        if (cctx == null) {
            cctx = new ConversationContext(cid);
            this.cctxMap.put(cid, cctx);
        } else if (cctx.getTerminationHandler() != null) {
            cctx.cancelTermination();
        }
    }

    public void clearupConversation(FacesContext context, String cid) {
        ConversationContext cctx = this.cctxMap.get(cid);
        if (cctx != null) {
            ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            long timeout = 120L;
            String conversationTimeout = servletContext.getInitParameter("CONVERSATION_TIMEOUT");
            if (conversationTimeout != null) {
                try {
                    timeout = Long.parseLong(conversationTimeout);
                }
                catch (NumberFormatException e) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("parse of CONVERSATION_TIMEOUT: '").append(conversationTimeout).append("' error, it must be an integer, use default CONVERSATION_TIMEOUT 120s");
                    this.logger.log(Level.INFO, buf.toString());
                    e.printStackTrace();
                }
            }
            this.rescheduleForTermination(context, cctx, timeout *= 1000L);
        }
    }

    public void rescheduleForTermination(FacesContext context, ConversationContext cctx, long timeout) {
        if (cctx.getTerminationHandler() != null && !cctx.getTerminationHandler().isCancelled()) {
            cctx.getTerminationHandler().cancel(false);
        }
        TerminationTask task = new TerminationTask((ServletContext)context.getExternalContext().getContext(), cctx);
        ScheduledFuture<?> terminationHandler = ThreadScheduledExecutorService.getInstance(context).schedule(task, timeout, TimeUnit.MILLISECONDS);
        cctx.setTerminationHandler(terminationHandler);
    }

    public class TerminationTask
    implements Runnable {
        private ConversationContext cctx;
        private ServletContext sctxt;

        public TerminationTask(ServletContext sctxt, ConversationContext cctx) {
            this.sctxt = sctxt;
            this.cctx = cctx;
        }

        public void run() {
            String cid = this.cctx.getId();
            if (!this.cctx.getTerminationHandler().isCancelled()) {
                ConversationContextManager.this.logger.finer("remove ConversationId : " + cid);
                this.destroyConversationBeans(this.cctx);
                ConversationContextManager.this.cctxMap.remove(cid);
            }
        }

        private void destroyConversationBeans(ConversationContext cctxt) {
            Map<String, Object> map = cctxt.getConversationMap();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String beanName = entry.getKey();
                this.destroyBean(beanName, entry.getValue(), ManagedBeanScope.CONVERSATION);
            }
        }

        private void destroyBean(String beanName, Object bean, ManagedBeanScope scope) {
            try {
                ManagedBeanFactory factory;
                ManagedBeanContainer container = ManagedBeanContainer.getInstance(this.sctxt);
                if (container != null && (factory = container.getBeanFactory(beanName)) != null && scope == factory.getScope() && factory.isInstance(bean)) {
                    factory.destroyBean(bean);
                }
            }
            catch (Throwable ex) {
                ConversationContextManager.this.logger.log(Level.FINE, ex.getMessage(), ex);
            }
        }
    }
}

