/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.conversation;

import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.operamasks.faces.conversation.ConversationContextManager;
import org.operamasks.faces.conversation.ConversationHelper;
import org.operamasks.faces.conversation.ConversationIdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversationPhaseListener
implements PhaseListener {
    public void beforePhase(PhaseEvent event) {
        if (PhaseId.RESTORE_VIEW.equals(event.getPhaseId())) {
            this.beforeRestoreView(event.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent event) {
    }

    private void beforeRestoreView(FacesContext context) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        this.initCidGenerator(context, sessionMap);
        String cid = this.initConversationId(context);
        ConversationContextManager cctxManager = this.initConversationContextManager(sessionMap);
        cctxManager.beginOrRestoreCctx(cid);
    }

    private void initCidGenerator(FacesContext context, Map<String, Object> sessionMap) {
        if (ConversationHelper.getCidGenerator(context) == null) {
            sessionMap.put("_ConversationIdGenerator_", new ConversationIdGenerator());
        }
    }

    private ConversationContextManager initConversationContextManager(Map<String, Object> sessionMap) {
        Object cctxManager = sessionMap.get("_ConersationContextManager_");
        if (cctxManager == null) {
            cctxManager = new ConversationContextManager();
            sessionMap.put("_ConersationContextManager_", cctxManager);
        }
        return (ConversationContextManager)cctxManager;
    }

    private String initConversationId(FacesContext context) {
        String cid = ConversationHelper.getCidFromRequest(context);
        if (cid == null) {
            cid = ConversationHelper.getCidGenerator(context).nextId();
        }
        ConversationHelper.setCurrentCid(context, cid);
        return cid;
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

