/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.convert;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.HtmlEncoder;
import org.operamasks.faces.validator.ClientValidator;
import org.operamasks.resources.Resources;

public class DateTimeConverter
extends javax.faces.convert.DateTimeConverter
implements ClientValidator {
    public DateTimeConverter() {
        TimeZone initTimeZone = FacesUtils.getInitTimeZone();
        if (initTimeZone != null) {
            super.setTimeZone(initTimeZone);
        }
    }

    public String getValidatorScript(FacesContext context, UIComponent component) {
        return null;
    }

    public String getValidatorInstanceScript(FacesContext context, UIComponent component) {
        try {
            SimpleDateFormat format;
            Locale locale = this.getLocale();
            if (locale == null) {
                locale = context.getViewRoot().getLocale();
            }
            if ((format = this.getDateFormat(locale)) == null) {
                return null;
            }
            Compiler c = new Compiler(format.toPattern(), format.getDateFormatSymbols());
            c.compile();
            String message = (String)component.getAttributes().get("converterMessage");
            if (message == null) {
                message = Resources._T("JSF_DATETIME_CONVERTER", FacesUtils.getLabel(context, component), format.toPattern());
            }
            return "new ClientValidator(" + HtmlEncoder.enquote(message, Character.valueOf('\'')) + "," + "function(value){" + c.generate() + "})";
        }
        catch (Exception ex) {
            return null;
        }
    }

    private SimpleDateFormat getDateFormat(Locale locale) {
        DateFormat df;
        String pattern = this.getPattern();
        String type = this.getType();
        if (pattern == null && type == null) {
            return null;
        }
        int dateStyle = DateTimeConverter.getStyle(this.getDateStyle());
        int timeStyle = DateTimeConverter.getStyle(this.getTimeStyle());
        if (pattern != null) {
            df = new SimpleDateFormat(pattern, locale);
        } else if (type.equals("both")) {
            df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        } else if (type.equals("date")) {
            df = DateFormat.getDateInstance(dateStyle, locale);
        } else if (type.equals("time")) {
            df = DateFormat.getTimeInstance(timeStyle, locale);
        } else {
            return null;
        }
        if (df instanceof SimpleDateFormat) {
            df.setLenient(false);
            return df;
        }
        return null;
    }

    private static int getStyle(String name) {
        if ("default".equals(name)) {
            return 2;
        }
        if ("short".equals(name)) {
            return 3;
        }
        if ("medium".equals(name)) {
            return 2;
        }
        if ("long".equals(name)) {
            return 1;
        }
        if ("full".equals(name)) {
            return 0;
        }
        throw new IllegalArgumentException();
    }

    private static class Compiler {
        private String pattern;
        private DateFormatSymbols symbols;
        private StringBuilder output;
        private int yearPlace;
        private int yearDigits;
        private int monthPlace;
        private int monthDigits;
        private int datePlace;
        private int lastPlace;

        public Compiler(String pattern, DateFormatSymbols symbols) {
            this.pattern = pattern;
            this.symbols = symbols;
        }

        private void initialize() {
            this.output = new StringBuilder();
            this.datePlace = -1;
            this.monthPlace = -1;
            this.yearPlace = -1;
            this.monthDigits = 0;
            this.yearDigits = 0;
            this.lastPlace = 0;
        }

        public void compile() {
            this.initialize();
            int length = this.pattern.length();
            boolean inQuote = false;
            int count = 0;
            int lastTag = -1;
            for (int i = 0; i < length; ++i) {
                int c = this.pattern.charAt(i);
                if (c == 39) {
                    if (i + 1 < length && (c = this.pattern.charAt(i + 1)) == 39) {
                        ++i;
                        if (count != 0) {
                            this.encode(lastTag, count);
                            lastTag = -1;
                            count = 0;
                        }
                        this.output.append("\\'");
                        continue;
                    }
                    if (!inQuote) {
                        if (count != 0) {
                            this.encode(lastTag, count);
                            lastTag = -1;
                            count = 0;
                        }
                        inQuote = true;
                        continue;
                    }
                    inQuote = false;
                    continue;
                }
                if (inQuote) {
                    this.encodeChar((char)c);
                    continue;
                }
                if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90)) {
                    if (count != 0) {
                        this.encode(lastTag, count);
                        lastTag = -1;
                        count = 0;
                    }
                    this.encodeChar((char)c);
                    continue;
                }
                int tag = c;
                if (lastTag == -1 || lastTag == tag) {
                    lastTag = tag;
                    ++count;
                    continue;
                }
                this.encode(lastTag, count);
                lastTag = tag;
                count = 1;
            }
            if (count != 0) {
                this.encode(lastTag, count);
            }
        }

        private void encodeChar(char c) {
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '/': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    this.output.append('\\').append(c);
                    break;
                }
                case '\t': 
                case ' ': {
                    this.output.append("\\s+");
                    break;
                }
                default: {
                    this.output.append(c);
                }
            }
        }

        private void encode(int tag, int count) {
            switch (tag) {
                case 71: {
                    String[] eras = this.symbols.getEras();
                    this.output.append("(?:");
                    this.output.append(eras[0]);
                    this.output.append('|');
                    this.output.append(eras[1]);
                    this.output.append(")");
                    break;
                }
                case 121: {
                    this.yearPlace = ++this.lastPlace;
                    this.yearDigits = count;
                    this.output.append("(\\d{1,4})");
                    break;
                }
                case 77: {
                    int i;
                    this.monthPlace = ++this.lastPlace;
                    this.monthDigits = count;
                    if (count <= 2) {
                        this.output.append("(0?[1-9]|1[0-2])");
                        break;
                    }
                    String[] months = this.symbols.getShortMonths();
                    this.output.append('(');
                    this.output.append(months[0]);
                    for (i = 1; i < 12; ++i) {
                        this.output.append('|');
                        this.output.append(months[i]);
                    }
                    months = this.symbols.getMonths();
                    for (i = 0; i < 12; ++i) {
                        this.output.append('|');
                        this.output.append(months[i]);
                    }
                    this.output.append(')');
                    break;
                }
                case 119: {
                    this.output.append("\\d{1,2}");
                    break;
                }
                case 87: {
                    this.output.append("\\d");
                    break;
                }
                case 68: {
                    this.output.append("\\d{1,3}");
                    break;
                }
                case 100: {
                    this.datePlace = ++this.lastPlace;
                    this.output.append("(\\d{1,2})");
                    break;
                }
                case 70: {
                    this.output.append("\\d{1,2}");
                    break;
                }
                case 69: {
                    int i;
                    String[] weakdays = this.symbols.getShortWeekdays();
                    this.output.append("(?:");
                    this.output.append(weakdays[0]);
                    for (i = 1; i < 7; ++i) {
                        this.output.append('|');
                        this.output.append(weakdays[i]);
                    }
                    weakdays = this.symbols.getWeekdays();
                    for (i = 0; i < 7; ++i) {
                        this.output.append('|');
                        this.output.append(weakdays[i]);
                    }
                    this.output.append(")");
                    break;
                }
                case 97: {
                    String[] ampm = this.symbols.getAmPmStrings();
                    this.output.append("(?:");
                    this.output.append(ampm[0]);
                    this.output.append('|');
                    this.output.append(ampm[1]);
                    this.output.append(")");
                    break;
                }
                case 72: {
                    this.output.append("(?:[01]?[0-9]|2[0-3])");
                    break;
                }
                case 107: {
                    this.output.append("(?:0?[1-9]|1[0-9]|2[0-4])");
                    break;
                }
                case 75: {
                    this.output.append("(?:0?[0-9]|1[01])");
                    break;
                }
                case 104: {
                    this.output.append("(?:0?[1-9]|1[012])");
                    break;
                }
                case 109: 
                case 115: {
                    this.output.append("(?:[0-5]?[0-9])");
                    break;
                }
                case 83: {
                    this.output.append("\\d{1,3}");
                    break;
                }
                case 122: {
                    this.output.append("(?:\\w{3}|GMT[-+](?:[01]?[0-9]|2[0-3]):[0-5][0-9])");
                    break;
                }
                case 90: {
                    this.output.append("[-+](?:[01][0-9]|2[0-3])[0-5][0-9]");
                }
            }
        }

        public String generate() {
            StringBuilder code = new StringBuilder();
            code.append("value=value.trim();");
            code.append("if(value.length==0)return true;");
            code.append("var r=value.match(/^").append((CharSequence)this.output).append("$/);");
            code.append("if(r==null)return false;");
            if (this.yearPlace != -1 && this.monthPlace != -1 && this.datePlace != -1) {
                String yearVal = "r[" + this.yearPlace + "]";
                String monthVal = "r[" + this.monthPlace + "]";
                String dateVal = "r[" + this.datePlace + "]";
                code.append("var y=parseInt(").append(yearVal).append(",10);");
                if (this.yearDigits <= 2) {
                    Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
                    calendar.setTime(new Date());
                    calendar.add(1, -80);
                    int centuryStartYear = calendar.get(1);
                    code.append("if(").append(yearVal).append(".length<=2)");
                    code.append("y+=").append(centuryStartYear / 100 * 100);
                    code.append("+(y<").append(centuryStartYear % 100).append("?100:0);");
                }
                if (this.monthDigits > 2) {
                    int i;
                    String[] months = this.symbols.getShortMonths();
                    code.append("var m=[");
                    for (i = 0; i < 12; ++i) {
                        if (i != 0) {
                            code.append(',');
                        }
                        code.append(HtmlEncoder.enquote(months[i], Character.valueOf('\'')));
                    }
                    code.append("].indexOf(").append(monthVal).append(")+1;");
                    months = this.symbols.getMonths();
                    code.append("if(m==-1)");
                    code.append("m=[");
                    for (i = 0; i < 12; ++i) {
                        if (i != 0) {
                            code.append(',');
                        }
                        code.append(HtmlEncoder.enquote(months[i], Character.valueOf('\'')));
                    }
                    code.append("].indexOf(").append(monthVal).append(")+1;");
                    code.append("if(m==-1)return false;");
                } else {
                    code.append("var m=parseInt(").append(monthVal).append(",10);");
                }
                code.append("var d=parseInt(").append(dateVal).append(",10);");
                code.append("switch(m){");
                code.append("case 2:if(d>((y%4==0&&(y%100!=0||y%400==0))?29:28))return false;break;");
                code.append("case 1:case 3:case 5:case 7:case 8:case 10:case 12:");
                code.append("if(d>31)return false;break;");
                code.append("default:if(d>30)return false;break;");
                code.append("}");
            }
            code.append("return true;");
            return code.toString();
        }
    }
}

