/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.convert;

import java.util.TimeZone;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.operamasks.resources.Resources;

public class DefaultDateTimeConverter
extends DateTimeConverter {
    public DefaultDateTimeConverter() {
        this.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
    }

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        try {
            return super.getAsObject(context, component, value);
        }
        catch (ConverterException ex) {
            if (ex.getFacesMessage() == null && ex.getMessage() != null) {
                String msgStr = Resources._T("JSF_DATETIME_CONVERTER_GENERAL_EXCEPTION", ex.getMessage());
                FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, msgStr, msgStr);
                throw new ConverterException(facesMsg, ex.getCause());
            }
            throw ex;
        }
    }
}

