/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.debug;

import java.lang.reflect.Method;
import java.util.logging.Level;
import javax.faces.component.UIComponent;
import javax.faces.render.Renderer;
import org.operamasks.faces.debug.Debug;
import org.operamasks.faces.debug.DebugMode;
import org.operamasks.faces.interceptor.AbstractInterceptor;
import org.operamasks.faces.interceptor.InvokeContext;

public class DebugInterceptor
extends AbstractInterceptor {
    private static final String KEY_AFTER_METHOD_CALL = "AFTER_METHOD_CALL";
    private static final String KEY_BEFORE_METHOD_CALL = "BEFORE_METHOD_CALL";
    private long startTime;

    private void beforeMethodCall(Object obj, Method method, UIComponent component, String resourceKey) {
        Debug.getLogger().log(Level.INFO, resourceKey, new Object[]{this.getTargetClassName(obj), method.getName(), component.getId()});
    }

    private void afterMethodCall(Object obj, Method method, UIComponent component, long processTime, String resourceKey) {
        Debug.getLogger().log(Level.INFO, resourceKey, new Object[]{this.getTargetClassName(obj), method.getName(), component.getId(), processTime});
    }

    private String getTargetClassName(Object proxy) {
        int enhanceFlagIndex;
        String className = proxy.getClass().getName();
        if (className.startsWith("$")) {
            className = className.substring(1);
        }
        if ((enhanceFlagIndex = className.indexOf("$$")) != -1) {
            className = className.substring(0, enhanceFlagIndex);
        }
        return className;
    }

    public void beforeInvoke(InvokeContext context) throws Throwable {
        this.startTime = System.currentTimeMillis();
        Object obj = context.getTarget();
        Method method = context.getMethod();
        Object[] args = context.getArgs();
        if (obj instanceof UIComponent) {
            this.beforeMethodCall(obj, method, (UIComponent)obj, KEY_BEFORE_METHOD_CALL);
        }
        if (obj instanceof Renderer) {
            this.beforeMethodCall(obj, method, (UIComponent)args[1], KEY_BEFORE_METHOD_CALL);
        }
    }

    public boolean isMatch(InvokeContext context) {
        Object obj = context.getTarget();
        Method method = context.getMethod();
        Object[] args = context.getArgs();
        if (obj instanceof UIComponent) {
            return Debug.isDebugComponentMethod(method, (UIComponent)obj);
        }
        if (obj instanceof Renderer) {
            return Debug.isDebugRendererMethod(method, args);
        }
        return super.isMatch(context);
    }

    public void onException(InvokeContext context, Throwable t) throws Throwable {
        if (Debug.isEnabled(DebugMode.EXCEPTION)) {
            Debug.getLogger().log(Level.INFO, context.getTarget().getClass().getName() + "." + context.getMethod().getName() + " throws a exception", t);
        }
        throw t;
    }

    public void afterInvoke(InvokeContext context) throws Throwable {
        long processTime = System.currentTimeMillis() - this.startTime;
        Object obj = context.getTarget();
        Method method = context.getMethod();
        Object[] args = context.getArgs();
        if (obj instanceof UIComponent) {
            this.afterMethodCall(obj, method, (UIComponent)obj, processTime, KEY_AFTER_METHOD_CALL);
        }
        if (obj instanceof Renderer) {
            this.afterMethodCall(obj, method, (UIComponent)args[1], processTime, KEY_AFTER_METHOD_CALL);
        }
    }
}

