/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyResolver;
import org.operamasks.el.eval.TypeCoercion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyResolverChainWrapper
extends ELResolver {
    private PropertyResolver legacyResolver;

    public PropertyResolverChainWrapper(PropertyResolver legacyResolver) {
        this.legacyResolver = legacyResolver;
    }

    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        if (base == null || property == null) {
            return null;
        }
        try {
            context.setPropertyResolved(true);
            if (base instanceof List || base.getClass().isArray()) {
                int index = TypeCoercion.coerceToInt((Object)property);
                return this.legacyResolver.getValue(base, index);
            }
            return this.legacyResolver.getValue(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws ELException {
        if (base == null || property == null) {
            return null;
        }
        try {
            context.setPropertyResolved(true);
            if (base instanceof List || base.getClass().isArray()) {
                int index = TypeCoercion.coerceToInt((Object)property);
                return this.legacyResolver.getType(base, index);
            }
            return this.legacyResolver.getType(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws ELException {
        if (base == null || property == null) {
            return;
        }
        try {
            context.setPropertyResolved(true);
            if (base instanceof List || base.getClass().isArray()) {
                int index = TypeCoercion.coerceToInt((Object)property);
                this.legacyResolver.setValue(base, index, value);
            } else {
                this.legacyResolver.setValue(base, property, value);
            }
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws ELException {
        if (base == null || property == null) {
            return false;
        }
        try {
            context.setPropertyResolved(true);
            if (base instanceof List || base.getClass().isArray()) {
                int index = TypeCoercion.coerceToInt((Object)property);
                return this.legacyResolver.isReadOnly(base, index);
            }
            return this.legacyResolver.isReadOnly(base, property);
        }
        catch (EvaluationException ex) {
            context.setPropertyResolved(false);
            throw new ELException((Throwable)ex);
        }
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return Object.class;
        }
        return null;
    }
}

