/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.operamasks.faces.event.ModelEvent;
import org.operamasks.faces.event.ModelEventListener;

public class ThreadLocalEventBroadcaster {
    private static final String ALL_EVENT_TYPE = "*";
    private Map<String, ArrayList<ModelEventListener>> listeners = new HashMap<String, ArrayList<ModelEventListener>>();
    private static ThreadLocal<ThreadLocalEventBroadcaster> instance = new ThreadLocal<ThreadLocalEventBroadcaster>(){

        @Override
        protected ThreadLocalEventBroadcaster initialValue() {
            return null;
        }
    };

    public static ThreadLocalEventBroadcaster getInstance() {
        ThreadLocalEventBroadcaster currentIns = instance.get();
        if (currentIns == null) {
            currentIns = new ThreadLocalEventBroadcaster();
        }
        return currentIns;
    }

    public static void setInstance(ThreadLocalEventBroadcaster broadcaster) {
        instance.set(broadcaster);
    }

    private ThreadLocalEventBroadcaster() {
        ThreadLocalEventBroadcaster.setInstance(this);
    }

    public void addEventListenerOnce(String eventType, ModelEventListener listener) {
        ArrayList<ModelEventListener> l;
        if (!this.listeners.containsKey(eventType)) {
            this.listeners.put(eventType, new ArrayList());
        }
        if (!(l = this.listeners.get(eventType)).contains(listener)) {
            l.add(listener);
        }
    }

    public void addEventListener(String eventType, ModelEventListener listener) {
        if (!this.listeners.containsKey(eventType)) {
            this.listeners.put(eventType, new ArrayList());
        }
        this.listeners.get(eventType).add(listener);
    }

    public void removeEventListener(String eventType, ModelEventListener listener) {
        ArrayList<ModelEventListener> l = this.listeners.get(eventType);
        if (l == null) {
            return;
        }
        l.remove(listener);
    }

    public void removeEventType(String eventType) {
        this.listeners.remove(eventType);
    }

    public void clear() {
        this.listeners.clear();
    }

    public void broadcast(Object source, String eventType, Object ... params) {
        if (eventType == null || eventType.length() == 0 || eventType.equals(ALL_EVENT_TYPE)) {
            throw new IllegalArgumentException(eventType);
        }
        ModelEvent event = new ModelEvent(source, eventType, params);
        String key = eventType;
        while (true) {
            int sep;
            List list;
            if ((list = (List)this.listeners.get(key)) != null) {
                int s = list.size();
                for (int i = 0; i < s; ++i) {
                    ModelEventListener listener = (ModelEventListener)list.get(i);
                    listener.processModelEvent(event);
                }
            }
            if ((sep = key.lastIndexOf(46)) != -1) {
                key = key.substring(0, sep);
                continue;
            }
            if (key.equals(ALL_EVENT_TYPE)) break;
            key = ALL_EVENT_TYPE;
        }
    }
}

