/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.lifecycle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import org.operamasks.faces.lifecycle.LifecycleImpl;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleFactoryImpl
extends LifecycleFactory {
    private Map<String, Lifecycle> lifecycles = new HashMap<String, Lifecycle>();

    public LifecycleFactoryImpl() {
        this.addLifecycle("DEFAULT", new LifecycleImpl());
    }

    public void addLifecycle(String lifecycleId, Lifecycle lifecycle) {
        if (lifecycleId == null || lifecycle == null) {
            throw new NullPointerException();
        }
        if (this.lifecycles.containsKey(lifecycleId)) {
            throw new IllegalArgumentException(Resources._T("JSF_DUPLICATE_LIFECYCLE_ID", lifecycleId));
        }
        this.lifecycles.put(lifecycleId, lifecycle);
    }

    public Lifecycle getLifecycle(String lifecycleId) throws FacesException {
        if (lifecycleId == null) {
            throw new NullPointerException();
        }
        Lifecycle result = this.lifecycles.get(lifecycleId);
        if (result == null) {
            throw new IllegalArgumentException(Resources._T("JSF_NO_SUCH_LIFECYCLE_ID", lifecycleId));
        }
        return result;
    }

    public Iterator<String> getLifecycleIds() {
        return this.lifecycles.keySet().iterator();
    }
}

