/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.lifecycle;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.lifecycle.ApplyRequestValues;
import org.operamasks.faces.lifecycle.InvokeApplication;
import org.operamasks.faces.lifecycle.Phase;
import org.operamasks.faces.lifecycle.ProcessValidations;
import org.operamasks.faces.lifecycle.RenderResponse;
import org.operamasks.faces.lifecycle.RestoreView;
import org.operamasks.faces.lifecycle.UpdateModelValues;
import org.operamasks.faces.util.LoggerUtil;

public class LifecycleImpl
extends Lifecycle {
    protected static final Logger log = LoggerUtil.getLogger("org.operamasks.faces.lifecycle");
    private ApplicationAssociate associate;
    private List<PhaseListener> phaseListeners;
    private Phase[] phases = new Phase[]{new RestoreView(), new ApplyRequestValues(), new ProcessValidations(), new UpdateModelValues(), new InvokeApplication()};
    private Phase renderResponse = new RenderResponse();
    private static final PhaseListener[] EMPTY_PHASE_LISTENERS = new PhaseListener[0];

    public LifecycleImpl() {
        this.phaseListeners = new CopyOnWriteArrayList<PhaseListener>();
    }

    private ApplicationAssociate getAssociate(FacesContext context) {
        if (this.associate == null) {
            this.associate = ApplicationAssociate.getInstance(context);
        }
        return this.associate;
    }

    public void execute(FacesContext context) throws FacesException {
        try {
            this.getAssociate(context).requestMade();
            ViewHandler viewHandler = context.getApplication().getViewHandler();
            viewHandler.initView(context);
            for (Phase phase : this.phases) {
                if (phase.skipPhase(context)) break;
                this.doPhase(phase, context);
            }
        }
        catch (FacesException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public void render(FacesContext context) throws FacesException {
        try {
            if (!this.renderResponse.skipPhase(context)) {
                this.doPhase(this.renderResponse, context);
            }
        }
        catch (FacesException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public void addPhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.phaseListeners.add(listener);
    }

    public void removePhaseListener(PhaseListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.phaseListeners.remove(listener);
    }

    public PhaseListener[] getPhaseListeners() {
        if (this.phaseListeners.isEmpty()) {
            return EMPTY_PHASE_LISTENERS;
        }
        return this.phaseListeners.toArray(EMPTY_PHASE_LISTENERS);
    }

    private void doPhase(Phase phase, FacesContext context) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Request lifecycle phase '" + phase.getPhaseId() + "' started.");
        }
        context.getExternalContext().getRequestMap().put("org.operamasks.faces.CURRENT_PHASE_ID", phase.getPhaseId());
        this.notifyPhaseListeners(context, phase.getPhaseId(), true);
        if (!phase.skipPhase(context)) {
            phase.execute(context);
        }
        this.notifyPhaseListeners(context, phase.getPhaseId(), false);
    }

    private void notifyPhaseListeners(FacesContext context, PhaseId phaseId, boolean isBefore) {
        PhaseListener[] listeners = this.getPhaseListeners();
        if (listeners.length > 0) {
            PhaseEvent event = new PhaseEvent(context, phaseId, (Lifecycle)this);
            for (PhaseListener listener : listeners) {
                if (listener.getPhaseId() != phaseId && listener.getPhaseId() != PhaseId.ANY_PHASE) continue;
                if (isBefore) {
                    listener.beforePhase(event);
                    continue;
                }
                listener.afterPhase(event);
            }
        }
    }
}

