/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.lifecycle;

import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.lifecycle.Phase;

public class RestoreView
extends Phase {
    private ApplicationAssociate associate;
    private static final Logger logger = Logger.getLogger("RestoreView");

    public RestoreView() {
        super(PhaseId.RESTORE_VIEW);
    }

    private ApplicationAssociate getAssociate(FacesContext context) {
        if (this.associate == null) {
            this.associate = ApplicationAssociate.getInstance(context);
        }
        return this.associate;
    }

    public void execute(FacesContext context) {
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        viewHandler.initView(context);
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            view.setLocale(context.getExternalContext().getRequestLocale());
            ModelBindingFactory.applyModelBindings(context, PhaseId.RESTORE_VIEW);
            OMUtils.updateValueBindings(context, (UIComponent)view);
            return;
        }
        if (!FacesUtils.isPostback(context)) {
            String viewId = this.getAssociate(context).getViewId(context);
            if (viewId == null) {
                throw new FacesException("Cannot obtain request view ID");
            }
            view = viewHandler.createView(context, viewId);
            context.setViewRoot(view);
            context.renderResponse();
            return;
        }
        String viewId = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.ViewId");
        if (viewId != null && viewHandler instanceof ViewBuilder) {
            view = ((ViewBuilder)viewHandler).buildView(context, viewId);
        } else {
            viewId = this.getAssociate(context).getViewId(context);
            if (viewId == null) {
                throw new FacesException("Cannot obtain request view ID");
            }
            view = viewHandler.restoreView(context, viewId);
        }
        if (view != null) {
            context.setViewRoot(view);
            ModelBindingFactory.applyModelBindings(context, PhaseId.RESTORE_VIEW);
            OMUtils.updateValueBindings(context, (UIComponent)view);
            context.getExternalContext().getRequestMap().put("org.operamasks.faces.ORIGINAL_VIEW_ID", view.getViewId());
        } else {
            if (this.isStatePostback(context)) {
                logger.info("no found viewState to " + viewId);
            }
            view = viewHandler.createView(context, viewId);
            context.setViewRoot(view);
            context.renderResponse();
        }
    }

    private boolean isStatePostback(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        return paramMap.containsKey("javax.faces.ViewState");
    }
}

