/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import javax.servlet.http.HttpServletRequest;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.AbstractRenderKit;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseStateManager;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;

public class AjaxRenderKitImpl
extends AbstractRenderKit {
    public static final String AJAX_RENDER_KIT = "AJAX";
    public static final String AJAX_SUB_RENDER_KIT = ":AJAX";
    private static final String AJAX_REQUEST_HEADER = "X-Requested-By";
    private static final String AJAX_REQUEST_VALUE = "XMLHttpRequest";
    private RenderKit delegate;
    private ResponseStateManager stateManager = new AjaxResponseStateManager();

    public static boolean isAjaxResponse(FacesContext context) {
        String renderKitId = context.getViewRoot().getRenderKitId();
        if (renderKitId == null) {
            return false;
        }
        if (!AJAX_RENDER_KIT.equals(renderKitId) && !renderKitId.endsWith(AJAX_SUB_RENDER_KIT)) {
            return false;
        }
        Object requestObj = context.getExternalContext().getRequest();
        if (!(requestObj instanceof HttpServletRequest)) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)requestObj;
        String header = request.getHeader(AJAX_REQUEST_HEADER);
        if (!AJAX_REQUEST_VALUE.equals(header)) {
            return false;
        }
        String originalViewId = (String)request.getAttribute("org.operamasks.faces.ORIGINAL_VIEW_ID");
        String currentViewId = context.getViewRoot().getViewId();
        return originalViewId == null || currentViewId.equals(originalViewId);
    }

    public Renderer getRenderer(String family, String rendererType) {
        RenderKit delegate;
        Renderer renderer = this.getPrivateRenderer(family, rendererType);
        if (renderer == null && (delegate = this.getDelegateRenderKit()) != null) {
            renderer = delegate.getRenderer(family, rendererType);
        }
        return renderer;
    }

    protected RenderKit getDelegateRenderKit() {
        if (this.delegate == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.delegate = FacesUtils.getRenderKit(context, "HTML_BASIC");
        }
        return this.delegate;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.stateManager;
    }

    protected ResponseWriter implCreateResponseWriter(Writer writer, String contentType, String encoding) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (AjaxRenderKitImpl.isAjaxResponse(context)) {
            return new AjaxResponseWriter(writer, contentType, encoding);
        }
        return new AjaxHtmlResponseWriter(writer, contentType, encoding);
    }
}

