/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.ajax;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.ajax.PartialUpdateCandidates;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.util.HtmlEncoder;

public class AjaxResponseWriter
extends ResponseWriter {
    public static final String OUTJECTED_KEY = "__outjected__";
    private Writer out;
    private String contentType;
    private String encoding;
    private Stack<Element> stack = new Stack();
    private Element current;
    private boolean viewStateChanged;
    private boolean writeFullState;
    private String actionScript;
    private static final String EMPTY_STRING = "''";

    AjaxResponseWriter(Writer out, String contentType, String encoding) {
        this.out = out;
        this.contentType = contentType;
        this.encoding = encoding;
        if (!FacesUtils.isTransientStateSupported(FacesContext.getCurrentInstance())) {
            this.writeFullState = true;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void setViewStateChanged() {
        this.viewStateChanged = true;
        if (!this.writeFullState && !FacesUtils.isMarkedForTransientState(FacesContext.getCurrentInstance())) {
            this.writeFullState = true;
        }
    }

    public void setViewStateChanged(boolean writeFullState) {
        this.viewStateChanged = true;
        if (writeFullState) {
            this.writeFullState = true;
        }
    }

    public boolean isViewStateChanged() {
        return this.viewStateChanged;
    }

    public boolean isWriteFullState() {
        return this.writeFullState;
    }

    public void addRequestParameter(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        try {
            if (value != null) {
                this.writeScriptBlock(String.format("OM.ajax.addRequestParameter(%s,%s);", HtmlEncoder.enquote(key), HtmlEncoder.enquote(value)));
            } else {
                this.writeScriptBlock(String.format("OM.ajax.removeRequestParameter(%s);", HtmlEncoder.enquote(key)));
            }
            this.setViewStateChanged(false);
        }
        catch (IOException ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this.viewStateChanged) {
            String[] state = FacesUtils.getViewState(context);
            if (this.writeFullState) {
                this.out.write(this.omE("OM.ajax.viewId=null;"));
            } else {
                this.out.write(this.omE("OM.ajax.viewId='" + context.getViewRoot().getViewId() + "';"));
            }
            if (state[0] != null) {
                this.out.write(this.omE("OM.ajax.viewState='" + state[0] + "';"));
            }
            if (state[1] != null) {
                this.out.write(this.omE("OM.ajax.renderKitId='" + state[1] + "';"));
            }
        }
        if (this.actionScript != null) {
            this.writeScriptBlock(this.actionScript);
        }
        if (ComponentResource.getShowClientException().booleanValue()) {
            this.out.write("OM.L();");
        }
    }

    private String omE(String script) {
        if (!ComponentResource.getCatchAllException().booleanValue()) {
            return script;
        }
        if (script == null || script.length() == 0) {
            return "";
        }
        return "OM.E(function(){" + script + "});\n";
    }

    public void flush() throws IOException {
    }

    public void startElement(String name, UIComponent component) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.current != null) {
            this.stack.push(this.current);
        }
        this.current = new Element(name, component);
    }

    public void writeAttribute(String name, Object value, String property) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.current == null) {
            throw new IllegalStateException();
        }
        if (this.current.component == null) {
            return;
        }
        if (name.equals("id")) {
            if (value != null) {
                this.current.id = value.toString();
            }
        } else {
            this.current.addAttribute(name, value, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        String valueStr = value == null ? "" : value.toString();
        String uri = HtmlEncoder.encodeURI(valueStr, this.encoding);
        this.writeAttribute(name, uri, property);
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.current != null && this.current.component != null && this.current.id != null) {
            String str = text == null ? "" : text.toString();
            boolean dynamic = this.needUpdate(this.current.component, property);
            this.current.addText(str, dynamic);
        }
    }

    public void writeText(char[] text, int off, int len) {
        if (this.current != null && this.current.component != null && this.current.id != null) {
            this.current.addText(text, off, len);
        }
    }

    public void write(char[] cbuf, int off, int len) {
        if (this.current != null && this.current.component != null && this.current.id != null) {
            this.current.addText(cbuf, off, len);
        }
    }

    public void write(int c) {
        if (this.current != null && this.current.component != null && this.current.id != null) {
            this.current.addText(c);
        }
    }

    public void write(String str, int off, int len) {
        if (this.current != null && this.current.component != null && this.current.id != null) {
            this.current.addText(str.substring(off, off + len), false);
        }
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.current == null || !this.current.name.equals(name)) {
            throw new IllegalStateException();
        }
        if (this.current.component != null && this.current.id != null) {
            for (Attribute att : this.current.getAttributes()) {
                if (!this.needUpdate(this.current.component, att.property)) continue;
                this.writeAttributeScript(this.current.id, att.name, att.value);
                PartialUpdateCandidates.getInstance().getAttributeCandidates(this.current.component).remove(att.property);
            }
            if (this.current.dynamicText) {
                this.writeInnerHtmlScript(this.current.id, this.current.getText());
                PartialUpdateCandidates.getInstance().getAttributeCandidates(this.current.component).remove("value");
            }
        }
        this.current = null;
        if (!this.stack.isEmpty()) {
            this.current = this.stack.pop();
        }
    }

    public void writeAttributeScript(String id, String name, Object value) throws IOException {
        if (name.equals("style")) {
            String strValue = value == null ? EMPTY_STRING : HtmlEncoder.enquote(value.toString(), Character.valueOf('\''));
            this.out.write("OM.S('" + id + "'," + strValue + ");\n");
        } else {
            if (name.equals("class")) {
                name = "className";
            }
            if (name.equals("bgcolor")) {
                name = "bgColor";
            }
            String strValue = value == null ? EMPTY_STRING : (value instanceof Boolean ? value.toString() : HtmlEncoder.enquote(value.toString(), Character.valueOf('\'')));
            this.out.write("OM.F('" + id + "','" + name + "'," + strValue + ");\n");
        }
    }

    public void writeInnerHtmlScript(String id, String text) throws IOException {
        this.out.write("OM.T('" + id + "'," + HtmlEncoder.enquote(text, Character.valueOf('\'')) + ");\n");
    }

    public void writeScript(String text) throws IOException {
        this.out.write(text);
    }

    public void writeScriptBlock(String text) throws IOException {
        this.out.write(this.omE(text));
    }

    public void writeScriptBlockBegin(String text) throws IOException {
        if (ComponentResource.getCatchAllException().booleanValue()) {
            this.out.write("OM.E(function(){" + text);
        } else {
            this.out.write(text);
        }
    }

    public void writeScriptBlockEnd(String text) throws IOException {
        if (ComponentResource.getCatchAllException().booleanValue()) {
            this.out.write(text + "});");
        } else {
            this.out.write(text);
        }
    }

    public void writeActionScript(String script) {
        this.actionScript = this.actionScript == null ? script : this.actionScript + script;
    }

    public void writeComment(Object data) {
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new AjaxResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
    }

    public AjaxHtmlResponseWriter cloneWithHtmlWriter(Writer writer) {
        return new AjaxHtmlResponseWriter(writer, this);
    }

    public void close() {
    }

    private boolean needUpdate(UIComponent component, String property) {
        PartialUpdateCandidates uc = PartialUpdateCandidates.getInstance();
        if ("value".equals(property)) {
            return uc.isUpdateValue(component);
        }
        Set<String> attrs = uc.getAttributeCandidates(component);
        return attrs.contains(property);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Element {
        String name;
        String id;
        UIComponent component;
        List<Attribute> attributes;
        StringBuffer textBuf;
        boolean dynamicText;

        public Element(String name, UIComponent component) {
            this.name = name;
            this.component = component;
        }

        public void addAttribute(String name, Object value, String property) {
            Attribute att = new Attribute();
            att.name = name;
            att.value = value;
            att.property = property;
            if (this.attributes == null) {
                this.attributes = new ArrayList<Attribute>();
            }
            this.attributes.add(att);
        }

        public void addText(String text, boolean dynamic) {
            if (this.textBuf == null) {
                this.textBuf = new StringBuffer();
            }
            this.textBuf.append(text);
            if (dynamic) {
                this.dynamicText = true;
            }
        }

        public void addText(char[] text, int off, int len) {
            if (this.textBuf == null) {
                this.textBuf = new StringBuffer();
            }
            this.textBuf.append(text, off, len);
        }

        public void addText(int c) {
            if (this.textBuf == null) {
                this.textBuf = new StringBuffer();
            }
            this.textBuf.append((char)c);
        }

        public List<Attribute> getAttributes() {
            if (this.attributes == null) {
                return Collections.emptyList();
            }
            return this.attributes;
        }

        public String getText() {
            return this.textBuf == null ? "" : this.textBuf.toString();
        }
    }

    private static class Attribute {
        String name;
        Object value;
        String property;

        private Attribute() {
        }
    }
}

