/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.encoder;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.operamasks.faces.developer.ajax.LiteAttributeEncoder;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.util.HtmlEncoder;

public class HtmlAttributeEncoder
implements LiteAttributeEncoder {
    private static final String EMPTY_STRING = "''";
    private String property;
    private String name;

    public HtmlAttributeEncoder(String property, String name) {
        this.property = property;
        this.name = name;
    }

    public void encode(FacesContext context, UIComponent component, AjaxResponseWriter out, String jsvar) throws IOException {
        String clientId = component.getClientId(context);
        Object value = component.getAttributes().get(this.property);
        if (this.name != null) {
            if (this.name.equals("style")) {
                String strValue = value == null ? EMPTY_STRING : HtmlEncoder.enquote(value.toString(), Character.valueOf('\''));
                out.writeScript("OM.S('" + clientId + "'," + strValue + ");\n");
            } else {
                if (value instanceof Boolean) {
                    out.writeScript("OM.F('" + clientId + "','" + this.name + "', " + value + " );\n");
                    return;
                }
                if (this.name.equals("class")) {
                    this.name = "className";
                }
                if (this.name.equals("bgcolor")) {
                    this.name = "bgColor";
                }
                String strValue = value == null ? EMPTY_STRING : HtmlEncoder.enquote(value.toString(), Character.valueOf('\''));
                out.writeScript("OM.F('" + clientId + "','" + this.name + "'," + strValue + ");\n");
            }
        }
    }
}

