/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.render.common.RendererUtils;
import org.operamasks.faces.render.html.UIOutputRenderer;

public class FormatRenderer
extends UIOutputRenderer {
    public void renderCurrentValue(FacesContext context, UIComponent component, String currentValue) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String message = this.formatMessage(component, currentValue);
        boolean wroteSpan = false;
        if (RendererUtils.shouldWriteIdAttribute(context, component) || RendererUtils.hasPassThruAttributes(component)) {
            out.startElement("span", component);
            RendererUtils.writeIdAttributeIfNecessary(context, out, component);
            RendererUtils.renderPassThruAttributes(out, component);
            wroteSpan = true;
        }
        if (RendererUtils.needsEscape(component)) {
            out.writeText((Object)message, "value");
        } else {
            out.write(message);
        }
        if (wroteSpan) {
            out.endElement("span");
        }
    }

    public String formatMessage(UIComponent component, String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        Object[] params = this.getParameters(component);
        if (params != null) {
            return MessageFormat.format(value, params);
        }
        return value;
    }

    protected Object[] getParameters(UIComponent component) {
        ArrayList<Object> paramList = null;
        for (UIComponent kid : component.getChildren()) {
            if (!(kid instanceof UIParameter)) continue;
            if (paramList == null) {
                paramList = new ArrayList<Object>();
            }
            paramList.add(((UIParameter)kid).getValue());
        }
        if (paramList == null) {
            return null;
        }
        return paramList.toArray();
    }
}

