/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.ButtonStub;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.faces.render.resource.AbstractResource;
import org.operamasks.faces.render.resource.ResourceManager;
import org.operamasks.faces.util.LoggerUtil;

public abstract class HtmlRenderer
extends Renderer {
    protected static final Logger log = LoggerUtil.getLogger("org.operamasks.faces.view");
    private static final String SUBMIT_FUNCTION_NAME = "_OM_submit";
    private static final String SUBMIT_FUNCTION = "function _OM_submit(id,params,target){\nvar f = document.forms[id];var t = f.target;var ap = new Array();if (target){f.target = target;}for (var i=0; i < params.length; i+=2){var p = document.createElement('input');p.type = 'hidden';p.name = params[i];p.value = params[i+1];f.appendChild(p);ap.push(p);}try{f.submit();}finally{f.target = t;for (var i = 0; i < ap.length; i++){f.removeChild(ap[i]);}}}";
    private static final String[][] PASSTHRU_ATTRIBUTES = new String[][]{{"accept", "accept"}, {"acceptcharset", "accept-charset"}, {"accesskey", "accesskey"}, {"align", "align"}, {"alt", "alt"}, {"bgcolor", "bgcolor"}, {"border", "border"}, {"cellpadding", "cellpadding"}, {"cellspacing", "cellspacing"}, {"charset", "charset"}, {"cols", "cols"}, {"colspan", "colspan"}, {"coords", "coords"}, {"dir", "dir"}, {"disabled", "disabled", "disabled"}, {"enctype", "enctype"}, {"frame", "frame"}, {"height", "height"}, {"hreflang", "hreflang"}, {"ismap", "ismap", "ismap"}, {"lang", "lang"}, {"longdesc", "longdesc"}, {"maxlength", "maxlength"}, {"onblur", "onblur"}, {"onchange", "onchange"}, {"onclick", "onclick"}, {"ondblclick", "ondblclick"}, {"onfocus", "onfocus"}, {"onkeydown", "onkeydown"}, {"onkeypress", "onkeypress"}, {"onkeyup", "onkeyup"}, {"onload", "onload"}, {"onmousedown", "onmousedown"}, {"onmousemove", "onmousemove"}, {"onmouseout", "onmouseout"}, {"onmouseover", "onmouseover"}, {"onmouseup", "onmouseup"}, {"onreset", "onreset"}, {"onselect", "onselect"}, {"onsubmit", "onsubmit"}, {"onunload", "onunload"}, {"readonly", "readonly", "readonly"}, {"rel", "rel"}, {"rev", "rev"}, {"rows", "rows"}, {"rowspan", "rowspan"}, {"rules", "rules"}, {"shape", "shape"}, {"size", "size"}, {"style", "style"}, {"styleClass", "class"}, {"summary", "summary"}, {"tabIndex", "tabindex"}, {"tabindex", "tabindex"}, {"target", "target"}, {"title", "title"}, {"usemap", "usemap"}, {"valign", "valign"}, {"width", "width"}};
    private static ConcurrentHashMap<String, String[][]> passthruAttributesWithExclusion = new ConcurrentHashMap();
    private static final String[] EMPTY_ELEMENTS = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};

    public static UIForm getParentForm(UIComponent component) {
        while (component != null) {
            if (component instanceof UIForm) {
                return (UIForm)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static String getActionURL(FacesContext context) {
        String viewId = context.getViewRoot().getViewId();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        return context.getExternalContext().encodeActionURL(url);
    }

    private static void encodeSubmitFunction(FacesContext context) {
        ResourceManager rm = ResourceManager.getInstance(context);
        rm.registerResource(new AbstractResource("urn:function:submit_form"){

            public void encodeEnd(FacesContext context) throws IOException {
                ResponseWriter out = context.getResponseWriter();
                out.startElement("script", null);
                out.writeAttribute("type", (Object)"text/javascript", null);
                out.writeAttribute("language", (Object)"Javascript", null);
                out.write(HtmlRenderer.SUBMIT_FUNCTION);
                out.endElement("script");
            }
        });
    }

    public static String encodeSubmit(FacesContext context, UIForm form, String target, String ... params) {
        HtmlRenderer.encodeSubmitFunction(context);
        StringBuilder buf = new StringBuilder();
        buf.append(SUBMIT_FUNCTION_NAME);
        buf.append("('").append(form.getClientId(context)).append("',[");
        for (int i = 0; i < params.length; i += 2) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(params[i]).append(",").append(params[i + 1]);
        }
        buf.append("]");
        if (target != null) {
            buf.append(",'").append(target).append("'");
        }
        buf.append(");");
        return buf.toString();
    }

    public static String encodeAjaxSubmit(FacesContext context, UIComponent component, String ... params) {
        UIForm form = HtmlRenderer.getParentForm(component);
        boolean immediate = component instanceof UICommand ? ((UICommand)component).isImmediate() : false;
        StringBuilder buf = new StringBuilder();
        buf.append("OM.ajax.submit(");
        if (form != null || params.length != 0 || immediate) {
            if (form != null) {
                buf.append("'").append(form.getClientId(context)).append("',");
            } else {
                buf.append("null,");
            }
            buf.append("null,");
            if (params.length == 0) {
                buf.append("null,");
            } else {
                buf.append("{");
                for (int i = 0; i < params.length; i += 2) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    buf.append(params[i]);
                    buf.append(":");
                    buf.append(params[i + 1]);
                }
                buf.append("},");
            }
            buf.append(immediate);
            buf.append(",'").append(component.getClientId(context)).append("'");
            if (component instanceof ButtonStub) {
                buf.append(",").append(FacesUtils.getJsvar(context, component));
            }
        }
        buf.append(");");
        return buf.toString();
    }

    public static boolean isDisabled(UIComponent component) {
        Object disabled = component.getAttributes().get("disabled");
        if (disabled != null) {
            if (disabled instanceof String) {
                return ((String)disabled).equalsIgnoreCase("true");
            }
            return disabled.equals(Boolean.TRUE);
        }
        return false;
    }

    public static boolean isReadonly(UIComponent component) {
        Object readonly = component.getAttributes().get("readonly");
        if (readonly != null) {
            if (readonly instanceof String) {
                return ((String)readonly).equalsIgnoreCase("true");
            }
            return readonly.equals(Boolean.TRUE);
        }
        return false;
    }

    public static boolean isDisabledOrReadonly(UIComponent component) {
        return HtmlRenderer.isDisabled(component) || HtmlRenderer.isReadonly(component);
    }

    public static boolean needsEscape(UIComponent component) {
        Object escape = component.getAttributes().get("escape");
        if (escape != null) {
            if (escape instanceof String) {
                return ((String)escape).equalsIgnoreCase("true");
            }
            return escape.equals(Boolean.TRUE);
        }
        return false;
    }

    protected boolean isAjaxResponse(FacesContext context) {
        return context.getResponseWriter() instanceof AjaxResponseWriter;
    }

    protected boolean isAjaxHtmlResponse(FacesContext context) {
        return context.getResponseWriter() instanceof AjaxHtmlResponseWriter;
    }

    protected boolean shouldWriteIdAttribute(FacesContext context, UIComponent component) {
        if (component.isTransient()) {
            return false;
        }
        if (this.isAjaxResponse(context) || this.isAjaxHtmlResponse(context)) {
            return true;
        }
        String id = component.getId();
        return id != null && !id.startsWith("j_id");
    }

    protected boolean writeIdAttributeIfNecessary(FacesContext context, ResponseWriter writer, UIComponent component) throws IOException {
        if (this.shouldWriteIdAttribute(context, component)) {
            String id = component.getClientId(context);
            writer.writeAttribute("id", (Object)id, "clientId");
            return true;
        }
        return false;
    }

    private static String[][] getPassThruAttributes(String exclusion) {
        if (exclusion == null) {
            return PASSTHRU_ATTRIBUTES;
        }
        String[][] passthruAttributes = passthruAttributesWithExclusion.get(exclusion);
        if (passthruAttributes == null) {
            String[] excludes = exclusion.split(",");
            passthruAttributes = new String[PASSTHRU_ATTRIBUTES.length - excludes.length][];
            int next = 0;
            for (int i = 0; i < PASSTHRU_ATTRIBUTES.length; ++i) {
                String name = PASSTHRU_ATTRIBUTES[i][0];
                boolean skip = false;
                for (int j = 0; j < excludes.length; ++j) {
                    if (!name.equals(excludes[j])) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                passthruAttributes[next++] = PASSTHRU_ATTRIBUTES[i];
            }
            assert (next == passthruAttributes.length);
            passthruAttributesWithExclusion.put(exclusion, passthruAttributes);
        }
        return passthruAttributes;
    }

    public static boolean hasPassThruAttributes(UIComponent component) {
        return HtmlRenderer.hasPassThruAttributes(component, null);
    }

    public static boolean hasPassThruAttributes(UIComponent component, String exclusion) {
        if (component == null) {
            return false;
        }
        Map attrs = component.getAttributes();
        for (String[] attribute : HtmlRenderer.getPassThruAttributes(exclusion)) {
            Object value = attrs.get(attribute[0]);
            if (value == null || "".equals(value)) continue;
            return true;
        }
        return false;
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        HtmlRenderer.renderPassThruAttributes(writer, component, null);
    }

    public static void renderPassThruAttributes(ResponseWriter writer, UIComponent component, String exclusion) throws IOException {
        for (String[] attribute : HtmlRenderer.getPassThruAttributes(exclusion)) {
            Object value = component.getAttributes().get(attribute[0]);
            if (value == null) continue;
            if (attribute.length == 3) {
                Boolean result = value instanceof Boolean ? (Boolean)value : Boolean.valueOf(value.toString());
                writer.writeAttribute(attribute[1], (Object)result, attribute[0]);
                continue;
            }
            if (!HtmlRenderer.shouldRenderAttribute(value)) continue;
            writer.writeAttribute(attribute[1], (Object)value.toString(), attribute[0]);
        }
    }

    private static boolean shouldRenderAttribute(Object attributeValue) {
        switch (TypeCoercion.typeof((Object)attributeValue)) {
            case 1: {
                return (Boolean)attributeValue != false;
            }
            case 2: {
                return (Byte)attributeValue != -128;
            }
            case 3: {
                return ((Character)attributeValue).charValue() != '\u0000';
            }
            case 4: {
                return (Short)attributeValue != Short.MIN_VALUE;
            }
            case 5: {
                return (Integer)attributeValue != Integer.MIN_VALUE;
            }
            case 6: {
                return (Long)attributeValue != Long.MIN_VALUE;
            }
            case 7: {
                return ((Float)attributeValue).floatValue() != Float.MIN_VALUE;
            }
            case 8: {
                return (Double)attributeValue != Double.MIN_VALUE;
            }
        }
        return true;
    }

    public static boolean isEmptyElement(String name) {
        return Arrays.binarySearch(EMPTY_ELEMENTS, name.toLowerCase()) >= 0;
    }
}

