/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.HtmlPageRendererStub;
import org.operamasks.faces.internal.stub.component.HtmlPageStub;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.render.resource.ComponentResource;
import org.operamasks.faces.util.HtmlEncoder;

public class HtmlResponseWriter
extends ResponseWriter {
    protected Writer out;
    private String contentType;
    private String encoding;
    private boolean dontEscape;
    private int state = 2;
    private static final int START_ELEMENT = 0;
    private static final int END_ELEMENT = 1;
    private static final int TEXT = 2;
    private boolean escapeText;
    private boolean escapeTextSet;
    private static final String ESCAPE_TEXT_PARAM = "org.operamasks.faces.ESCAPE_TEXT";

    public HtmlResponseWriter(Writer out, String contentType, String encoding) {
        this.out = out;
        this.contentType = contentType;
        this.encoding = encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
        HtmlPageRendererStub renderer;
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = context.getViewRoot();
        UIComponent page = (UIComponent)FacesUtils.findComponent((UIComponent)viewRoot, HtmlPageStub.class);
        if (!(page != null && page.isRendered() || (renderer = this.getHtmlPageRenderer(context)) == null)) {
            renderer.encodePageBegin(context, (UIComponent)viewRoot);
        }
    }

    public void endDocument() throws IOException {
        HtmlPageRendererStub renderer;
        this.closeStart();
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = context.getViewRoot();
        UIComponent page = (UIComponent)FacesUtils.findComponent((UIComponent)viewRoot, HtmlPageStub.class);
        if (!(page != null && page.isRendered() || (renderer = this.getHtmlPageRenderer(context)) == null)) {
            renderer.encodePageEnd(context, (UIComponent)viewRoot);
        }
        if (ComponentResource.getShowClientException().booleanValue()) {
            this.out.write("<script type=\"text/javascript\"><!--\nOM.L()\n--></script>");
        }
    }

    private HtmlPageRendererStub getHtmlPageRenderer(FacesContext context) {
        return (HtmlPageRendererStub)context.getRenderKit().getRenderer("org.operamasks.faces.HtmlDocument", "org.operamasks.faces.HtmlPage");
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.state == 0) {
            this.out.write(62);
        }
        this.out.write(60);
        this.out.write(name);
        this.state = 0;
        if (name.equalsIgnoreCase("script") || name.equalsIgnoreCase("style")) {
            this.dontEscape = true;
        }
    }

    public void endElement(String name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.state == 0) {
            if (OMUtils.isEmptyElement(name)) {
                this.out.write("/>");
            } else {
                this.out.write("></");
                this.out.write(name);
                this.out.write(">");
            }
        } else {
            this.out.write("</");
            this.out.write(name);
            this.out.write(62);
        }
        this.state = 1;
        if (name.equalsIgnoreCase("script") || name.equalsIgnoreCase("style")) {
            this.dontEscape = false;
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.state != 0) {
            throw new IllegalStateException("No current open element.");
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                this.out.write(32);
                this.out.write(name);
                this.out.write("=\"");
                this.out.write(name);
                this.out.write(34);
            }
        } else {
            if (value == null) {
                value = "";
            }
            this.out.write(32);
            this.out.write(name);
            this.out.write("=\"");
            HtmlEncoder.encode(this.out, value.toString());
            this.out.write(34);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.state != 0) {
            throw new IllegalStateException("No current open element.");
        }
        String valueStr = value == null ? "" : value.toString();
        this.out.write(32);
        this.out.write(name);
        this.out.write("=\"");
        HtmlEncoder.encodeURI(this.out, valueStr, this.encoding);
        this.out.write(34);
    }

    public void writeComment(Object data) throws IOException {
        this.closeStart();
        this.out.write("<!--");
        if (data != null) {
            String comment = data.toString();
            int length = comment.length();
            boolean sawDash = false;
            int i = 0;
            while (i < length) {
                char c = comment.charAt(i);
                if (c == '-') {
                    if (sawDash) {
                        this.out.write(32);
                    } else {
                        sawDash = true;
                    }
                } else {
                    sawDash = false;
                }
                this.out.write(c);
                ++i;
            }
            if (sawDash) {
                this.out.write(32);
            }
        }
        this.out.write("-->");
    }

    private void closeStart() throws IOException {
        if (this.state == 0) {
            this.out.write(62);
            this.state = 2;
        }
    }

    public void writeText(Object textObj, String property) throws IOException {
        String text;
        this.closeStart();
        String string = text = textObj == null ? "" : textObj.toString();
        if (this.dontEscape) {
            this.out.write(text);
        } else if (this.isEscapeText()) {
            HtmlEncoder.encode(this.out, text);
        } else {
            this.out.write(text);
        }
    }

    public void writeText(char[] text) throws IOException {
        this.writeText(text, 0, text.length);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.closeStart();
        if (this.dontEscape) {
            this.out.write(text, off, len);
        } else {
            HtmlEncoder.encode(this.out, text, off, len);
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new HtmlResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
    }

    public void close() throws IOException {
        this.closeStart();
        this.out.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStart();
        this.out.write(cbuf, off, len);
    }

    public void write(int c) throws IOException {
        this.closeStart();
        this.out.write(c);
    }

    public void write(String str) throws IOException {
        this.closeStart();
        this.out.write(str);
    }

    public void write(String str, int off, int len) throws IOException {
        this.closeStart();
        this.out.write(str, off, len);
    }

    private boolean isEscapeText() {
        if (this.escapeTextSet) {
            return this.escapeText;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            String paramValue = context.getExternalContext().getInitParameter(ESCAPE_TEXT_PARAM);
            this.escapeText = paramValue == null || paramValue != null && paramValue.equalsIgnoreCase("true");
            this.escapeTextSet = true;
        }
        return this.escapeText;
    }
}

