/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.render.common.HtmlBasicRendererBase;
import org.operamasks.faces.render.common.RendererUtils;

public class MessageRenderer
extends HtmlBasicRendererBase {
    public void encodeHtmlEnd(FacesContext context, UIComponent component) throws IOException {
        String title;
        FacesMessage message = MessageRenderer.getFacesMessage(context, component);
        if (message == null) {
            return;
        }
        String messageClass = "x-error-message";
        String style = null;
        String styleClass = null;
        if (message.getSeverity() == FacesMessage.SEVERITY_INFO) {
            style = (String)component.getAttributes().get("infoStyle");
            styleClass = (String)component.getAttributes().get("infoClass");
            messageClass = "x-info-message";
        } else if (message.getSeverity() == FacesMessage.SEVERITY_WARN) {
            style = (String)component.getAttributes().get("warnStyle");
            styleClass = (String)component.getAttributes().get("warnClass");
            messageClass = "x-warn-message";
        } else if (message.getSeverity() == FacesMessage.SEVERITY_ERROR) {
            style = (String)component.getAttributes().get("errorStyle");
            styleClass = (String)component.getAttributes().get("errorClass");
            messageClass = "x-error-message";
        } else if (message.getSeverity() == FacesMessage.SEVERITY_FATAL) {
            style = (String)component.getAttributes().get("fatalStyle");
            styleClass = (String)component.getAttributes().get("fatalClass");
            messageClass = "x-fatal-message";
        }
        if (style == null) {
            style = (String)component.getAttributes().get("style");
        }
        if (styleClass == null) {
            styleClass = (String)component.getAttributes().get("styleClass");
        }
        if (styleClass == null) {
            styleClass = messageClass;
        }
        boolean showSummary = ((UIMessage)component).isShowSummary();
        boolean showDetail = ((UIMessage)component).isShowDetail();
        String summary = message.getSummary();
        String detail = message.getDetail();
        if (summary == null) {
            summary = "";
        }
        if (detail == null) {
            detail = "";
        }
        Object tooltipVal = component.getAttributes().get("tooltip");
        boolean tooltip = false;
        if (tooltipVal instanceof Boolean) {
            tooltip = (Boolean)tooltipVal;
        }
        if ((title = (String)component.getAttributes().get("title")) == null && tooltip) {
            title = summary;
        }
        ResponseWriter out = context.getResponseWriter();
        out.startElement("span", component);
        RendererUtils.writeIdAttributeIfNecessary(context, out, component);
        if (style != null) {
            out.writeAttribute("style", (Object)style, "style");
        }
        if (styleClass != null) {
            out.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        if (title != null) {
            out.writeAttribute("title", (Object)title, "title");
        }
        RendererUtils.renderPassThruAttributes(out, component, "style,styleClass,title");
        if (showSummary && showDetail) {
            out.writeText((Object)(summary + " " + detail), null);
        } else if (showSummary) {
            out.writeText((Object)summary, null);
        } else if (showDetail) {
            out.writeText((Object)detail, null);
        }
        out.endElement("span");
    }

    public static FacesMessage getFacesMessage(FacesContext context, UIComponent component) {
        String id = ((UIMessage)component).getFor();
        if (id == null || id.length() == 0) {
            return null;
        }
        UIComponent forComponent = FacesUtils.getForComponent(context, id, component);
        if (forComponent == null) {
            return null;
        }
        String clientId = forComponent.getClientId(context);
        Iterator messageIter = context.getMessages(clientId);
        if (!messageIter.hasNext()) {
            return null;
        }
        return (FacesMessage)messageIter.next();
    }
}

